/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.builders.StatsbeatTelemetryBuilder;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.pipeline.TelemetryItemExporter;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.BaseStatsbeat;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.CustomDimensions;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.MetadataInstanceResponse;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.ResourceProvider;
import java.util.Collections;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

class AttachStatsbeat
extends BaseStatsbeat {
    private static final String ATTACH_METRIC_NAME = "Attach";
    private static final String UNKNOWN_RP_ID = "unknown";
    private static final String WEBSITE_SITE_NAME = "WEBSITE_SITE_NAME";
    private static final String WEBSITE_HOSTNAME = "WEBSITE_HOSTNAME";
    private static final String WEBSITE_HOME_STAMPNAME = "WEBSITE_HOME_STAMPNAME";
    private final CustomDimensions customDimensions;
    private final Function<String, String> systemGetenvFn;
    private volatile String resourceProviderId;
    private volatile MetadataInstanceResponse metadataInstanceResponse;

    AttachStatsbeat(CustomDimensions customDimensions) {
        super(customDimensions);
        this.customDimensions = customDimensions;
        this.systemGetenvFn = System::getenv;
        this.resourceProviderId = AttachStatsbeat.initResourceProviderId(customDimensions.getResourceProvider(), null, this.systemGetenvFn);
    }

    @Override
    protected void send(TelemetryItemExporter exporter) {
        if (this.resourceProviderId == null || this.resourceProviderId.isEmpty()) {
            this.resourceProviderId = AttachStatsbeat.initResourceProviderId(this.customDimensions.getResourceProvider(), null, this.systemGetenvFn);
        }
        StatsbeatTelemetryBuilder telemetryBuilder = this.createStatsbeatTelemetry(ATTACH_METRIC_NAME, 0.0);
        telemetryBuilder.addProperty("rpId", this.resourceProviderId);
        exporter.send(Collections.singletonList(telemetryBuilder.build()));
    }

    String getResourceProviderId() {
        return this.resourceProviderId;
    }

    MetadataInstanceResponse getMetadataInstanceResponse() {
        return this.metadataInstanceResponse;
    }

    void updateMetadataInstance(MetadataInstanceResponse response) {
        this.metadataInstanceResponse = response;
        this.resourceProviderId = AttachStatsbeat.initResourceProviderId(ResourceProvider.RP_VM, response, this.systemGetenvFn);
    }

    static String initResourceProviderId(ResourceProvider resourceProvider, @Nullable MetadataInstanceResponse response, Function<String, String> envVarFn) {
        switch (resourceProvider) {
            case RP_APPSVC: {
                return envVarFn.apply(WEBSITE_SITE_NAME) + "/" + envVarFn.apply(WEBSITE_HOME_STAMPNAME);
            }
            case RP_FUNCTIONS: {
                return envVarFn.apply(WEBSITE_HOSTNAME);
            }
            case RP_VM: {
                if (response != null) {
                    return response.getVmId() + "/" + response.getSubscriptionId();
                }
                return UNKNOWN_RP_ID;
            }
            case RP_AKS: {
                return envVarFn.apply("AKS_ARM_NAMESPACE_ID");
            }
            case UNKNOWN: {
                return UNKNOWN_RP_ID;
            }
        }
        return UNKNOWN_RP_ID;
    }
}

