/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.statsbeat.NetworkStatsbeat;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.StatusCode;
import java.util.concurrent.atomic.AtomicLong;
import reactor.core.publisher.Mono;

public class NetworkStatsbeatHttpPipelinePolicy
implements HttpPipelinePolicy {
    private static final String INSTRUMENTATION_KEY_DATA = "instrumentationKey";
    private final NetworkStatsbeat networkStatsbeat;

    public NetworkStatsbeatHttpPipelinePolicy(NetworkStatsbeat networkStatsbeat) {
        this.networkStatsbeat = networkStatsbeat;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        AtomicLong startTime = new AtomicLong();
        String host = context.getHttpRequest().getUrl().getHost();
        String instrumentationKey = context.getData(INSTRUMENTATION_KEY_DATA).orElse("unknown").toString();
        return next.process().doOnSubscribe(subscription -> startTime.set(System.currentTimeMillis())).doOnSuccess(response -> {
            int statusCode = response.getStatusCode();
            if (statusCode == 200) {
                this.networkStatsbeat.incrementRequestSuccessCount(System.currentTimeMillis() - startTime.get(), instrumentationKey, host);
            } else if (!StatusCode.isRedirect(statusCode)) {
                if (statusCode == 402 || statusCode == 439) {
                    this.networkStatsbeat.incrementThrottlingCount(instrumentationKey, host, "statusCode", statusCode);
                } else if (StatusCode.isRetryable(statusCode)) {
                    this.networkStatsbeat.incrementRetryCount(instrumentationKey, host, "statusCode", statusCode);
                } else {
                    this.networkStatsbeat.incrementRequestFailureCount(instrumentationKey, host, "statusCode", statusCode);
                }
            }
        }).doOnError(throwable -> this.networkStatsbeat.incrementExceptionCount(instrumentationKey, host, "exceptionType", throwable.getClass().getName()));
    }
}

