/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.utils;

import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.HostName;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.Strings;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.resources.Resource;

public final class AksResourceAttributes {
    private static final String AZURE_AKS = "azure_aks";
    private static final String UNKNOWN_SERVICE = "unknown_service";

    public static boolean isAks(Resource resource) {
        return AZURE_AKS.equals(resource.getAttribute(AttributeKey.stringKey((String)"cloud.platform")));
    }

    public static String getAksRoleName(Resource resource) {
        String serviceName = (String)resource.getAttribute(AttributeKey.stringKey((String)"service.name"));
        if (!Strings.isNullOrEmpty(serviceName) && !serviceName.startsWith(UNKNOWN_SERVICE)) {
            return serviceName;
        }
        String k8sDeploymentName = (String)resource.getAttribute(AttributeKey.stringKey((String)"k8s.deployment.name"));
        if (!Strings.isNullOrEmpty(k8sDeploymentName)) {
            return k8sDeploymentName;
        }
        String k8sReplicaSetName = (String)resource.getAttribute(AttributeKey.stringKey((String)"k8s.replicaset.name"));
        if (!Strings.isNullOrEmpty(k8sReplicaSetName)) {
            return k8sReplicaSetName;
        }
        String k8sStatefulSetName = (String)resource.getAttribute(AttributeKey.stringKey((String)"k8s.statefulset.name"));
        if (!Strings.isNullOrEmpty(k8sStatefulSetName)) {
            return k8sStatefulSetName;
        }
        String k8sJobName = (String)resource.getAttribute(AttributeKey.stringKey((String)"k8s.job.name"));
        if (!Strings.isNullOrEmpty(k8sJobName)) {
            return k8sJobName;
        }
        String k8sCronJobName = (String)resource.getAttribute(AttributeKey.stringKey((String)"k8s.cronjob.name"));
        if (!Strings.isNullOrEmpty(k8sCronJobName)) {
            return k8sCronJobName;
        }
        String k8sDaemonSetName = (String)resource.getAttribute(AttributeKey.stringKey((String)"k8s.daemonset.name"));
        if (!Strings.isNullOrEmpty(k8sDaemonSetName)) {
            return k8sDaemonSetName;
        }
        return serviceName;
    }

    public static String getAksRoleInstance(Resource resource) {
        String serviceInstanceId = (String)resource.getAttribute(AttributeKey.stringKey((String)"service.instance.id"));
        if (!Strings.isNullOrEmpty(serviceInstanceId)) {
            return serviceInstanceId;
        }
        String k8sPodName = (String)resource.getAttribute(AttributeKey.stringKey((String)"k8s.pod.name"));
        if (!Strings.isNullOrEmpty(k8sPodName)) {
            return k8sPodName;
        }
        return HostName.get();
    }
}

