/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.utils;

import java.util.concurrent.TimeUnit;

public final class FormattedDuration {
    private static final long NANOSECONDS_PER_DAY = TimeUnit.DAYS.toNanos(1L);
    private static final long NANOSECONDS_PER_HOUR = TimeUnit.HOURS.toNanos(1L);
    private static final long NANOSECONDS_PER_MINUTE = TimeUnit.MINUTES.toNanos(1L);
    private static final long NANOSECONDS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final ThreadLocal<StringBuilder> reusableStringBuilder = ThreadLocal.withInitial(StringBuilder::new);

    public static String fromNanos(long durationNanos) {
        long remainingNanos = durationNanos;
        long days = remainingNanos / NANOSECONDS_PER_DAY;
        long hours = (remainingNanos %= NANOSECONDS_PER_DAY) / NANOSECONDS_PER_HOUR;
        long minutes = (remainingNanos %= NANOSECONDS_PER_HOUR) / NANOSECONDS_PER_MINUTE;
        long seconds = (remainingNanos %= NANOSECONDS_PER_MINUTE) / NANOSECONDS_PER_SECOND;
        StringBuilder sb = reusableStringBuilder.get();
        sb.setLength(0);
        FormattedDuration.appendDaysHoursMinutesSeconds(sb, days, hours, minutes, seconds);
        FormattedDuration.appendMinSixDigits(sb, TimeUnit.NANOSECONDS.toMicros(remainingNanos %= NANOSECONDS_PER_SECOND));
        return sb.toString();
    }

    public static long getDurationFromTelemetryItemDurationString(String duration) {
        try {
            long microseconds;
            String hms;
            String[] parts = duration.split("\\.");
            int days = 0;
            if (parts.length == 3) {
                days = Integer.parseInt(parts[0]);
                hms = parts[1];
                microseconds = Integer.parseInt(parts[2]);
            } else {
                hms = parts[0];
                microseconds = Integer.parseInt(parts[1]);
            }
            String[] hmsParts = hms.split(":");
            int hours = Integer.parseInt(hmsParts[0]);
            int minutes = Integer.parseInt(hmsParts[1]);
            int seconds = Integer.parseInt(hmsParts[2]);
            return (long)days * 24L * 60L * 60L * 1000000L + (long)hours * 60L * 60L * 1000000L + (long)minutes * 60L * 1000000L + (long)seconds * 1000000L + microseconds;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static void appendDaysHoursMinutesSeconds(StringBuilder sb, long days, long hours, long minutes, long seconds) {
        if (days > 0L) {
            sb.append(days);
            sb.append('.');
        }
        FormattedDuration.appendMinTwoDigits(sb, hours);
        sb.append(':');
        FormattedDuration.appendMinTwoDigits(sb, minutes);
        sb.append(':');
        FormattedDuration.appendMinTwoDigits(sb, seconds);
        sb.append('.');
    }

    private static void appendMinTwoDigits(StringBuilder sb, long value) {
        if (value < 10L) {
            sb.append('0');
        }
        sb.append(value);
    }

    private static void appendMinSixDigits(StringBuilder sb, long value) {
        if (value < 100000L) {
            sb.append('0');
        }
        if (value < 10000L) {
            sb.append('0');
        }
        if (value < 1000L) {
            sb.append('0');
        }
        if (value < 100L) {
            sb.append('0');
        }
        if (value < 10L) {
            sb.append('0');
        }
        sb.append(value);
    }

    private FormattedDuration() {
    }
}

