/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.autoconfigure.implementation.utils;

import com.azure.core.util.CoreUtils;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.Strings;
import com.azure.monitor.opentelemetry.autoconfigure.implementation.utils.SystemInformation;
import java.util.Map;

public final class VersionGenerator {
    private static final String UNKNOWN_VERSION_VALUE = "unknown";
    private static final String sdkVersionString;

    private static String getPrefix() {
        return VersionGenerator.getResourceProvider() + VersionGenerator.getOs() + "_";
    }

    private static String getResourceProvider() {
        if ("java".equals(System.getenv("FUNCTIONS_WORKER_RUNTIME"))) {
            return "f";
        }
        if (!Strings.isNullOrEmpty(System.getenv("WEBSITE_SITE_NAME"))) {
            return "a";
        }
        if (!Strings.isNullOrEmpty(System.getenv("APPLICATIONINSIGHTS_SPRINGCLOUD_SERVICE_ID"))) {
            return "s";
        }
        if (!Strings.isNullOrEmpty(System.getenv("AKS_ARM_NAMESPACE_ID"))) {
            return "k";
        }
        return "u";
    }

    private static String getOs() {
        if (SystemInformation.isWindows()) {
            return "w";
        }
        if (SystemInformation.isLinux()) {
            return "l";
        }
        return "u";
    }

    public static String getSdkVersion() {
        return sdkVersionString;
    }

    private static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    private static String getJavaRuntime() {
        if (VersionGenerator.isGraalVmNative()) {
            return "!native";
        }
        return "";
    }

    private static boolean isGraalVmNative() {
        String imageCode = System.getProperty("org.graalvm.nativeimage.imagecode");
        return imageCode != null;
    }

    private static String getOpenTelemetryApiVersion() {
        Map properties = CoreUtils.getProperties((String)"io/opentelemetry/api/version.properties");
        if (properties == null) {
            return UNKNOWN_VERSION_VALUE;
        }
        String version = (String)properties.get("sdk.version");
        return version != null ? version : UNKNOWN_VERSION_VALUE;
    }

    private VersionGenerator() {
    }

    static {
        Map quarkusProperties;
        String quarkusVersion;
        String componentName = null;
        String componentVersion = null;
        Map springDistroProperties = CoreUtils.getProperties((String)"azure-spring-cloud-azure-starter-monitor.properties");
        String springDistroVersion = (String)springDistroProperties.get("version");
        if (springDistroVersion != null) {
            componentName = "dss";
            componentVersion = springDistroVersion;
        }
        if ((quarkusVersion = (String)(quarkusProperties = CoreUtils.getProperties((String)"quarkus-exporter.properties")).get("version")) != null) {
            componentName = "dsq";
            componentVersion = quarkusVersion;
        }
        if (componentName == null) {
            componentName = "ext";
            Map otelAutoconfigureProperties = CoreUtils.getProperties((String)"azure-monitor-opentelemetry-autoconfigure.properties");
            componentVersion = (String)otelAutoconfigureProperties.get("version");
        }
        sdkVersionString = VersionGenerator.getPrefix() + "java" + VersionGenerator.getJavaVersion() + VersionGenerator.getJavaRuntime() + ":otel" + VersionGenerator.getOpenTelemetryApiVersion() + ":" + componentName + componentVersion;
    }
}

