/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.monitor.opentelemetry.exporter.AzureMonitorExporterServiceVersion;
import com.azure.monitor.opentelemetry.exporter.AzureMonitorLogRecordExporter;
import com.azure.monitor.opentelemetry.exporter.AzureMonitorMetricExporter;
import com.azure.monitor.opentelemetry.exporter.AzureMonitorTraceExporter;
import com.azure.monitor.opentelemetry.exporter.NoopTracer;
import com.azure.monitor.opentelemetry.exporter.implementation.LogDataMapper;
import com.azure.monitor.opentelemetry.exporter.implementation.MetricDataMapper;
import com.azure.monitor.opentelemetry.exporter.implementation.SpanDataMapper;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.configuration.ConnectionString;
import com.azure.monitor.opentelemetry.exporter.implementation.heartbeat.HeartbeatExporter;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalStorageStats;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalStorageTelemetryPipelineListener;
import com.azure.monitor.opentelemetry.exporter.implementation.models.ContextTagKeys;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryItemExporter;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipeline;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineListener;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.ResourceParser;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.TempDirs;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.VersionGenerator;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class AzureMonitorExporterBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(AzureMonitorExporterBuilder.class);
    private static final String APPLICATIONINSIGHTS_CONNECTION_STRING = "APPLICATIONINSIGHTS_CONNECTION_STRING";
    private static final String APPLICATIONINSIGHTS_AUTHENTICATION_SCOPE = "https://monitor.azure.com//.default";
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-monitor-opentelemetry-exporter.properties");
    private ConnectionString connectionString;
    private TokenCredential credential;
    private AzureMonitorExporterServiceVersion serviceVersion;
    private HttpPipeline httpPipeline;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private RetryPolicy retryPolicy;
    private final List<HttpPipelinePolicy> httpPipelinePolicies = new ArrayList<HttpPipelinePolicy>();
    private Configuration configuration = Configuration.getGlobalConfiguration();
    private ClientOptions clientOptions;

    public AzureMonitorExporterBuilder httpPipeline(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        return this;
    }

    public AzureMonitorExporterBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public AzureMonitorExporterBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public AzureMonitorExporterBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public AzureMonitorExporterBuilder addHttpPipelinePolicy(HttpPipelinePolicy httpPipelinePolicy) {
        this.httpPipelinePolicies.add(Objects.requireNonNull(httpPipelinePolicy, "'policy' cannot be null."));
        return this;
    }

    public AzureMonitorExporterBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public AzureMonitorExporterBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public AzureMonitorExporterBuilder connectionString(String connectionString) {
        this.connectionString = ConnectionString.parse(connectionString);
        return this;
    }

    public AzureMonitorExporterBuilder serviceVersion(AzureMonitorExporterServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public AzureMonitorExporterBuilder credential(TokenCredential credential) {
        this.credential = credential;
        return this;
    }

    public SpanExporter buildTraceExporter() {
        SpanDataMapper mapper = new SpanDataMapper(true, this::populateDefaults, (event, instrumentationName) -> false, (span, event) -> false);
        return new AzureMonitorTraceExporter(mapper, this.initExporterBuilder());
    }

    public MetricExporter buildMetricExporter() {
        TelemetryItemExporter telemetryItemExporter = this.initExporterBuilder();
        HeartbeatExporter.start(TimeUnit.MINUTES.toSeconds(15L), this::populateDefaults, telemetryItemExporter::send);
        return new AzureMonitorMetricExporter(new MetricDataMapper(this::populateDefaults, true), telemetryItemExporter);
    }

    public LogRecordExporter buildLogRecordExporter() {
        return new AzureMonitorLogRecordExporter(new LogDataMapper(true, false, this::populateDefaults), this.initExporterBuilder());
    }

    private TelemetryItemExporter initExporterBuilder() {
        if (this.connectionString == null) {
            Configuration configuration = Configuration.getGlobalConfiguration();
            this.connectionString(configuration.get(APPLICATIONINSIGHTS_CONNECTION_STRING));
        }
        Objects.requireNonNull(this.connectionString, "'connectionString' cannot be null");
        if (this.credential != null) {
            BearerTokenAuthenticationPolicy authenticationPolicy = new BearerTokenAuthenticationPolicy(this.credential, new String[]{APPLICATIONINSIGHTS_AUTHENTICATION_SCOPE});
            this.httpPipelinePolicies.add((HttpPipelinePolicy)authenticationPolicy);
        }
        if (this.httpPipeline == null) {
            this.httpPipeline = this.createHttpPipeline();
        }
        TelemetryPipeline pipeline = new TelemetryPipeline(this.httpPipeline);
        File tempDir = TempDirs.getApplicationInsightsTempDir(LOGGER, "Telemetry will not be stored to disk and retried on sporadic network failures");
        TelemetryItemExporter telemetryItemExporter = tempDir != null ? new TelemetryItemExporter(pipeline, new LocalStorageTelemetryPipelineListener(50, TempDirs.getSubDir(tempDir, "telemetry"), pipeline, LocalStorageStats.noop(), false)) : new TelemetryItemExporter(pipeline, TelemetryPipelineListener.noop());
        return telemetryItemExporter;
    }

    private HttpPipeline createHttpPipeline() {
        Configuration buildConfiguration;
        Configuration configuration = buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        if (this.httpLogOptions == null) {
            this.httpLogOptions = new HttpLogOptions();
        }
        if (this.clientOptions == null) {
            this.clientOptions = new ClientOptions();
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = PROPERTIES.getOrDefault("name", "UnknownName");
        String clientVersion = PROPERTIES.getOrDefault("version", "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)this.clientOptions, (HttpLogOptions)this.httpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, buildConfiguration));
        policies.add(this.retryPolicy == null ? new RetryPolicy() : this.retryPolicy);
        policies.add(new CookiePolicy());
        policies.addAll(this.httpPipelinePolicies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).tracer((Tracer)new NoopTracer()).build();
    }

    void populateDefaults(AbstractTelemetryBuilder builder, Resource resource) {
        builder.setConnectionString(this.connectionString);
        builder.addTag(ContextTagKeys.AI_INTERNAL_SDK_VERSION.toString(), VersionGenerator.getSdkVersion());
        ResourceParser.updateRoleNameAndInstance(builder, resource, this.configuration);
    }
}

