/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.SpanDataMapper;
import com.azure.monitor.opentelemetry.exporter.implementation.logging.OperationLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.models.TelemetryItem;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryItemExporter;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.AzureMonitorMsgId;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.Collection;

final class AzureMonitorTraceExporter
implements SpanExporter {
    private static final ClientLogger LOGGER = new ClientLogger(AzureMonitorTraceExporter.class);
    private static final OperationLogger OPERATION_LOGGER = new OperationLogger(AzureMonitorTraceExporter.class, "Exporting span");
    private final TelemetryItemExporter telemetryItemExporter;
    private final SpanDataMapper mapper;

    AzureMonitorTraceExporter(SpanDataMapper mapper, TelemetryItemExporter telemetryItemExporter) {
        this.mapper = mapper;
        this.telemetryItemExporter = telemetryItemExporter;
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        ArrayList<TelemetryItem> telemetryItems = new ArrayList<TelemetryItem>();
        for (SpanData span : spans) {
            LOGGER.verbose("exporting span: {}", new Object[]{span});
            try {
                this.mapper.map(span, telemetryItems::add);
                OPERATION_LOGGER.recordSuccess();
            }
            catch (Throwable t) {
                OPERATION_LOGGER.recordFailure(t.getMessage(), t, AzureMonitorMsgId.EXPORTER_MAPPING_ERROR);
                return CompletableResultCode.ofFailure();
            }
        }
        return this.telemetryItemExporter.send(telemetryItems);
    }

    public CompletableResultCode flush() {
        return this.telemetryItemExporter.flush();
    }

    public CompletableResultCode shutdown() {
        return this.telemetryItemExporter.shutdown();
    }
}

