/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.pipeline;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.MetricTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.logging.OperationLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.models.ContextTagKeys;
import com.azure.monitor.opentelemetry.exporter.implementation.models.TelemetryItem;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.AppInsightsByteBufferPool;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.ByteBufferOutputStream;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipeline;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineListener;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.AksResourceAttributes;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.AzureMonitorMsgId;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;

public class TelemetryItemExporter {
    private static final int MAX_CONCURRENT_EXPORTS = 100;
    private static final String _OTELRESOURCE_ = "_OTELRESOURCE_";
    private static final ClientLogger logger = new ClientLogger(TelemetryItemExporter.class);
    private static final OperationLogger operationLogger = new OperationLogger(TelemetryItemExporter.class, "Put export into the background (don't wait for it to return)");
    private static final ObjectMapper mapper = TelemetryItemExporter.createObjectMapper();
    private static final AppInsightsByteBufferPool byteBufferPool = new AppInsightsByteBufferPool();
    private static final OperationLogger encodeBatchOperationLogger = new OperationLogger(TelemetryItemExporter.class, "Encoding telemetry batch into json");
    private final TelemetryPipeline telemetryPipeline;
    private final TelemetryPipelineListener listener;
    private final Set<CompletableResultCode> activeExportResults = Collections.newSetFromMap(new ConcurrentHashMap());

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.registerModules((Iterable)ObjectMapper.findModules((ClassLoader)TelemetryItemExporter.class.getClassLoader()));
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return mapper;
    }

    public TelemetryItemExporter(TelemetryPipeline telemetryPipeline, TelemetryPipelineListener listener) {
        this.telemetryPipeline = telemetryPipeline;
        this.listener = listener;
    }

    public CompletableResultCode send(List<TelemetryItem> telemetryItems) {
        List<List<TelemetryItem>> result = this.groupTelemetryItemsByConnectionStringAndRoleName(telemetryItems);
        ArrayList<CompletableResultCode> resultCodeList = new ArrayList<CompletableResultCode>();
        for (List<TelemetryItem> batch : result) {
            resultCodeList.add(this.internalSendByConnectionStringAndRoleName(batch, batch.get(0).getConnectionString()));
        }
        return this.maybeAddToActiveExportResults(resultCodeList);
    }

    List<List<TelemetryItem>> groupTelemetryItemsByConnectionStringAndRoleName(List<TelemetryItem> telemetryItems) {
        HashMap<String, List> groupings = new HashMap<String, List>();
        for (TelemetryItem telemetryItem : telemetryItems) {
            groupings.computeIfAbsent(telemetryItem.getConnectionString(), k -> new ArrayList()).add(telemetryItem);
        }
        ArrayList<List<TelemetryItem>> result = new ArrayList<List<TelemetryItem>>();
        for (List group : groupings.values()) {
            HashMap<String, List> roleNameGroupings = new HashMap<String, List>();
            for (TelemetryItem telemetryItem : group) {
                String roleName = "";
                if (telemetryItem.getTags() != null) {
                    roleName = telemetryItem.getTags().get(ContextTagKeys.AI_CLOUD_ROLE.toString());
                    roleName = roleName == null ? "" : roleName;
                }
                roleNameGroupings.computeIfAbsent(roleName, k -> new ArrayList()).add(telemetryItem);
            }
            result.addAll(roleNameGroupings.values());
        }
        return result;
    }

    private CompletableResultCode maybeAddToActiveExportResults(List<CompletableResultCode> results) {
        if (this.activeExportResults.size() >= 100) {
            operationLogger.recordFailure("Hit max 100 active concurrent requests", AzureMonitorMsgId.TELEMETRY_ITEM_EXPORTER_ERROR);
            return CompletableResultCode.ofAll(results);
        }
        operationLogger.recordSuccess();
        this.activeExportResults.addAll(results);
        for (CompletableResultCode result : results) {
            result.whenComplete(() -> this.activeExportResults.remove(result));
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofAll(this.activeExportResults);
    }

    public CompletableResultCode shutdown() {
        return this.listener.shutdown();
    }

    CompletableResultCode internalSendByConnectionStringAndRoleName(List<TelemetryItem> telemetryItems, String connectionString) {
        List<ByteBuffer> byteBuffers;
        if (!AksResourceAttributes.getOtelResourceAttributes().isEmpty() && !"Statsbeat".equals(telemetryItems.get(0).getName())) {
            telemetryItems.add(0, TelemetryItemExporter.createOtelResourceMetric(telemetryItems.get(0).getTags(), connectionString));
        }
        try {
            byteBuffers = this.encode(telemetryItems);
            encodeBatchOperationLogger.recordSuccess();
        }
        catch (Throwable t) {
            encodeBatchOperationLogger.recordFailure(t.getMessage(), t);
            return CompletableResultCode.ofFailure();
        }
        return this.telemetryPipeline.send(byteBuffers, connectionString, this.listener);
    }

    private static TelemetryItem createOtelResourceMetric(Map<String, String> existingTags, String connectionString) {
        MetricTelemetryBuilder builder = MetricTelemetryBuilder.create(_OTELRESOURCE_, 0.0);
        builder.setConnectionString(connectionString);
        builder.addTag(ContextTagKeys.AI_CLOUD_ROLE.toString(), existingTags.get(ContextTagKeys.AI_CLOUD_ROLE.toString()));
        builder.addTag(ContextTagKeys.AI_CLOUD_ROLE_INSTANCE.toString(), existingTags.get(ContextTagKeys.AI_CLOUD_ROLE_INSTANCE.toString()));
        builder.addTag(ContextTagKeys.AI_INTERNAL_SDK_VERSION.toString(), existingTags.get(ContextTagKeys.AI_INTERNAL_SDK_VERSION.toString()));
        for (Map.Entry<String, String> entry : AksResourceAttributes.getOtelResourceAttributes().entrySet()) {
            builder.addProperty(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    List<ByteBuffer> encode(List<TelemetryItem> telemetryItems) throws IOException {
        JsonGenerator jg;
        if (logger.canLogAtLevel(LogLevel.VERBOSE)) {
            StringWriter debug = new StringWriter();
            jg = mapper.createGenerator((Writer)debug);
            try {
                TelemetryItemExporter.writeTelemetryItems(jg, telemetryItems);
            }
            finally {
                if (jg != null) {
                    jg.close();
                }
            }
            logger.verbose("sending telemetry to ingestion service:{}{}", new Object[]{System.lineSeparator(), debug});
        }
        ByteBufferOutputStream out = new ByteBufferOutputStream(byteBufferPool);
        try {
            jg = mapper.createGenerator((OutputStream)new GZIPOutputStream(out));
            try {
                TelemetryItemExporter.writeTelemetryItems(jg, telemetryItems);
            }
            finally {
                if (jg != null) {
                    jg.close();
                }
            }
        }
        catch (IOException e) {
            byteBufferPool.offer(out.getByteBuffers());
            throw e;
        }
        out.close();
        List<ByteBuffer> byteBuffers = out.getByteBuffers();
        for (ByteBuffer byteBuffer : byteBuffers) {
            byteBuffer.flip();
        }
        return byteBuffers;
    }

    private static void writeTelemetryItems(JsonGenerator jg, List<TelemetryItem> telemetryItems) throws IOException {
        jg.setRootValueSeparator((SerializableString)new SerializedString("\n"));
        for (TelemetryItem telemetryItem : telemetryItems) {
            mapper.writeValue(jg, (Object)telemetryItem);
        }
    }
}

