/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.pipeline;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;

public class TelemetryPipelineRequest {
    private static final HttpHeaderName CONTENT_LENGTH = HttpHeaderName.fromString((String)"Content-Length");
    private static final HttpHeaderName USER_AGENT = HttpHeaderName.fromString((String)"User-Agent");
    private static final HttpHeaderName CONTENT_ENCODING = HttpHeaderName.fromString((String)"Content-Encoding");
    private volatile URL url;
    private final String connectionString;
    private final String instrumentationKey;
    private final List<ByteBuffer> telemetry;
    private final int contentLength;

    TelemetryPipelineRequest(URL url, String connectionString, String instrumentationKey, List<ByteBuffer> telemetry) {
        this.url = url;
        this.connectionString = connectionString;
        this.instrumentationKey = instrumentationKey;
        this.telemetry = telemetry;
        this.contentLength = telemetry.stream().mapToInt(Buffer::limit).sum();
    }

    public URL getUrl() {
        return this.url;
    }

    void setUrl(URL url) {
        this.url = url;
    }

    public List<ByteBuffer> getTelemetry() {
        return this.telemetry;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getInstrumentationKey() {
        return this.instrumentationKey;
    }

    HttpRequest createHttpRequest() {
        HttpRequest request = new HttpRequest(HttpMethod.POST, this.url);
        request.setBody(Flux.fromIterable(this.telemetry));
        request.setHeader(CONTENT_LENGTH, Integer.toString(this.contentLength));
        request.setHeader(USER_AGENT, "");
        request.setHeader(CONTENT_ENCODING, "gzip");
        return request;
    }
}

