/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.statsbeat;

import com.azure.monitor.opentelemetry.exporter.implementation.builders.StatsbeatTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryItemExporter;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.BaseStatsbeat;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.CustomDimensions;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.Feature;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.FeatureType;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.Instrumentations;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FeatureStatsbeat
extends BaseStatsbeat {
    private static final String FEATURE_METRIC_NAME = "Feature";
    private final Set<Feature> featureList = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> instrumentationList = Collections.newSetFromMap(new ConcurrentHashMap());
    private final FeatureType type;

    FeatureStatsbeat(CustomDimensions customDimensions, FeatureType type) {
        super(customDimensions);
        this.type = type;
        String javaVendor = System.getProperty("java.vendor");
        this.featureList.add(Feature.fromJavaVendor(javaVendor));
    }

    long getFeature() {
        return Feature.encode(this.featureList);
    }

    long[] getInstrumentation() {
        return Instrumentations.encode(this.instrumentationList);
    }

    public void addInstrumentation(String instrumentation) {
        this.instrumentationList.add(instrumentation);
    }

    public void addFeature(Feature feature) {
        this.featureList.add(feature);
    }

    @Override
    protected void send(TelemetryItemExporter telemetryItemExporter) {
        String featureType;
        String featureValue = "";
        if (this.type == FeatureType.FEATURE) {
            featureValue = String.valueOf(this.getFeature());
            featureType = "0";
        } else {
            long[] encodedLongArray = this.getInstrumentation();
            if (encodedLongArray.length == 1) {
                featureValue = String.valueOf(encodedLongArray[0]);
            } else if (encodedLongArray.length == 2) {
                featureValue = encodedLongArray[0] + "," + encodedLongArray[1];
            }
            featureType = "1";
        }
        StatsbeatTelemetryBuilder telemetryBuilder = this.createStatsbeatTelemetry(FEATURE_METRIC_NAME, 0.0);
        telemetryBuilder.addProperty("feature", featureValue);
        telemetryBuilder.addProperty("type", featureType);
        telemetryItemExporter.send(Collections.singletonList(telemetryBuilder.build()));
    }

    void trackConfigurationOptions(Set<Feature> featureSet) {
        this.featureList.addAll(featureSet);
    }
}

