/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.statsbeat;

import com.azure.monitor.opentelemetry.exporter.implementation.builders.StatsbeatTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryItemExporter;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.BaseStatsbeat;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.CustomDimensions;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.IntervalMetricsKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class NetworkStatsbeat
extends BaseStatsbeat {
    private static final String REQUEST_SUCCESS_COUNT_METRIC_NAME = "Request Success Count";
    private static final String REQUEST_FAILURE_COUNT_METRIC_NAME = "Request Failure Count";
    private static final String REQUEST_DURATION_METRIC_NAME = "Request Duration";
    private static final String RETRY_COUNT_METRIC_NAME = "Retry Count";
    private static final String THROTTLE_COUNT_METRIC_NAME = "Throttle Count";
    private static final String EXCEPTION_COUNT_METRIC_NAME = "Exception Count";
    private static final String BREEZE_ENDPOINT = "breeze";
    private static final Pattern hostPattern = Pattern.compile("^https?://(?:www\\.)?([^/.]+)");
    private final Object lock = new Object();
    private final Map<IntervalMetricsKey, IntervalMetrics> instrumentationKeyCounterMap = new HashMap<IntervalMetricsKey, IntervalMetrics>();

    NetworkStatsbeat() {
        super(new CustomDimensions());
    }

    NetworkStatsbeat(CustomDimensions customDimensions) {
        super(customDimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void send(TelemetryItemExporter telemetryItemExporter) {
        HashMap<IntervalMetricsKey, IntervalMetrics> local;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            local = new HashMap<IntervalMetricsKey, IntervalMetrics>(this.instrumentationKeyCounterMap);
            this.instrumentationKeyCounterMap.clear();
        }
        for (Map.Entry entry : local.entrySet()) {
            IntervalMetricsKey key = (IntervalMetricsKey)entry.getKey();
            this.sendIntervalMetric(telemetryItemExporter, key, (IntervalMetrics)entry.getValue());
        }
    }

    public void incrementRequestSuccessCount(long duration, String ikey, String host) {
        this.doWithIntervalMetrics(ikey, host, null, null, intervalMetrics -> {
            ((IntervalMetrics)intervalMetrics).requestSuccessCount.incrementAndGet();
            ((IntervalMetrics)intervalMetrics).totalRequestDuration.getAndAdd(duration);
        });
    }

    public void incrementRequestFailureCount(String ikey, String host, String causeFieldName, int statusCode) {
        this.doWithIntervalMetrics(ikey, host, causeFieldName, statusCode, intervalMetrics -> ((IntervalMetrics)intervalMetrics).requestFailureCount.incrementAndGet());
    }

    public void incrementRetryCount(String ikey, String host, String causeFieldName, int statusCode) {
        this.doWithIntervalMetrics(ikey, host, causeFieldName, statusCode, intervalMetrics -> ((IntervalMetrics)intervalMetrics).retryCount.incrementAndGet());
    }

    public void incrementThrottlingCount(String ikey, String host, String causeFieldName, int statusCode) {
        this.doWithIntervalMetrics(ikey, host, causeFieldName, statusCode, intervalMetrics -> ((IntervalMetrics)intervalMetrics).throttlingCount.incrementAndGet());
    }

    void incrementExceptionCount(String ikey, String host, String causeFieldName, String exceptionType) {
        this.doWithIntervalMetrics(ikey, host, causeFieldName, exceptionType, intervalMetrics -> ((IntervalMetrics)intervalMetrics).exceptionCount.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getRequestSuccessCount(String ikey, String host) {
        Object object = this.lock;
        synchronized (object) {
            IntervalMetrics intervalMetrics = this.instrumentationKeyCounterMap.get(IntervalMetricsKey.create(ikey, host, null, null));
            return intervalMetrics == null ? 0L : intervalMetrics.requestSuccessCount.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getRequestFailureCount(String ikey, String host, int statusCode) {
        Object object = this.lock;
        synchronized (object) {
            IntervalMetrics intervalMetrics = this.instrumentationKeyCounterMap.get(IntervalMetricsKey.create(ikey, host, "statusCode", statusCode));
            return intervalMetrics == null ? 0L : intervalMetrics.requestFailureCount.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double getRequestDurationAvg(String ikey, String host) {
        Object object = this.lock;
        synchronized (object) {
            IntervalMetrics intervalMetrics = this.instrumentationKeyCounterMap.get(IntervalMetricsKey.create(ikey, host, null, null));
            return intervalMetrics == null ? 0.0 : intervalMetrics.getRequestDurationAvg();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getRetryCount(String ikey, String host, int statusCode) {
        Object object = this.lock;
        synchronized (object) {
            IntervalMetrics intervalMetrics = this.instrumentationKeyCounterMap.get(IntervalMetricsKey.create(ikey, host, "statusCode", statusCode));
            return intervalMetrics == null ? 0L : intervalMetrics.retryCount.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getThrottlingCount(String ikey, String host, int statusCode) {
        Object object = this.lock;
        synchronized (object) {
            IntervalMetrics intervalMetrics = this.instrumentationKeyCounterMap.get(IntervalMetricsKey.create(ikey, host, "statusCode", statusCode));
            return intervalMetrics == null ? 0L : intervalMetrics.throttlingCount.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getExceptionCount(String ikey, String host, String exceptionType) {
        Object object = this.lock;
        synchronized (object) {
            IntervalMetrics intervalMetrics = this.instrumentationKeyCounterMap.get(IntervalMetricsKey.create(ikey, host, "exceptionType", exceptionType));
            return intervalMetrics == null ? 0L : intervalMetrics.exceptionCount.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWithIntervalMetrics(String ikey, String host, @Nullable String causeFieldName, @Nullable Object causeValue, Consumer<IntervalMetrics> update) {
        Object object = this.lock;
        synchronized (object) {
            IntervalMetrics intervalMetrics = this.instrumentationKeyCounterMap.computeIfAbsent(IntervalMetricsKey.create(ikey, host, causeFieldName, causeValue), k -> new IntervalMetrics());
            update.accept(intervalMetrics);
        }
    }

    private void sendIntervalMetric(TelemetryItemExporter telemetryItemExporter, IntervalMetricsKey key, IntervalMetrics local) {
        double durationAvg;
        if (local.requestSuccessCount.get() != 0L) {
            StatsbeatTelemetryBuilder requestSuccessCountSt = this.createStatsbeatTelemetry(REQUEST_SUCCESS_COUNT_METRIC_NAME, local.requestSuccessCount.get());
            NetworkStatsbeat.addCommonProperties(requestSuccessCountSt, key);
            telemetryItemExporter.send(Collections.singletonList(requestSuccessCountSt.build()));
        }
        if (local.requestFailureCount.get() != 0L) {
            StatsbeatTelemetryBuilder requestFailureCountSt = this.createStatsbeatTelemetry(REQUEST_FAILURE_COUNT_METRIC_NAME, local.requestFailureCount.get());
            NetworkStatsbeat.addCommonProperties(requestFailureCountSt, key);
            telemetryItemExporter.send(Collections.singletonList(requestFailureCountSt.build()));
        }
        if ((durationAvg = local.getRequestDurationAvg()) != 0.0) {
            StatsbeatTelemetryBuilder requestDurationSt = this.createStatsbeatTelemetry(REQUEST_DURATION_METRIC_NAME, durationAvg);
            NetworkStatsbeat.addCommonProperties(requestDurationSt, key);
            telemetryItemExporter.send(Collections.singletonList(requestDurationSt.build()));
        }
        if (local.retryCount.get() != 0L) {
            StatsbeatTelemetryBuilder retryCountSt = this.createStatsbeatTelemetry(RETRY_COUNT_METRIC_NAME, local.retryCount.get());
            NetworkStatsbeat.addCommonProperties(retryCountSt, key);
            telemetryItemExporter.send(Collections.singletonList(retryCountSt.build()));
        }
        if (local.throttlingCount.get() != 0L) {
            StatsbeatTelemetryBuilder throttleCountSt = this.createStatsbeatTelemetry(THROTTLE_COUNT_METRIC_NAME, local.throttlingCount.get());
            NetworkStatsbeat.addCommonProperties(throttleCountSt, key);
            telemetryItemExporter.send(Collections.singletonList(throttleCountSt.build()));
        }
        if (local.exceptionCount.get() != 0L) {
            StatsbeatTelemetryBuilder exceptionCountSt = this.createStatsbeatTelemetry(EXCEPTION_COUNT_METRIC_NAME, local.exceptionCount.get());
            NetworkStatsbeat.addCommonProperties(exceptionCountSt, key);
            telemetryItemExporter.send(Collections.singletonList(exceptionCountSt.build()));
        }
    }

    private static void addCommonProperties(StatsbeatTelemetryBuilder telemetryBuilder, IntervalMetricsKey key) {
        telemetryBuilder.addProperty("endpoint", BREEZE_ENDPOINT);
        telemetryBuilder.addProperty("cikey", key.getIkey());
        telemetryBuilder.addProperty("host", NetworkStatsbeat.shorten(key.getHost()));
        String causeFieldName = key.getCauseFieldName();
        Object cause = key.getCauseValue();
        if (causeFieldName != null && cause != null) {
            if (cause instanceof Integer) {
                telemetryBuilder.addProperty(causeFieldName, ((Integer)cause).toString());
            } else if (cause instanceof String) {
                telemetryBuilder.addProperty(causeFieldName, (String)cause);
            }
        }
    }

    static String shorten(String endpointUrl) {
        Matcher matcher = hostPattern.matcher(endpointUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return endpointUrl;
    }

    private static class IntervalMetrics {
        private final AtomicLong requestSuccessCount = new AtomicLong();
        private final AtomicLong requestFailureCount = new AtomicLong();
        private final AtomicLong totalRequestDuration = new AtomicLong();
        private final AtomicLong retryCount = new AtomicLong();
        private final AtomicLong throttlingCount = new AtomicLong();
        private final AtomicLong exceptionCount = new AtomicLong();

        private IntervalMetrics() {
        }

        private double getRequestDurationAvg() {
            double sum = this.totalRequestDuration.get();
            if (this.requestSuccessCount.get() != 0L) {
                return sum / (double)this.requestSuccessCount.get();
            }
            return sum;
        }
    }
}

