/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation;

import com.azure.monitor.opentelemetry.exporter.AzureMonitorExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collection;

public final class AzureMonitorMetricExporterProvider
implements ConfigurableMetricExporterProvider {
    public MetricExporter createExporter(ConfigProperties configProperties) {
        if (configProperties.getBoolean("_internal_using_azure_monitor_exporter_builder", false)) {
            return MarkerMetricExporter.INSTANCE;
        }
        throw new IllegalStateException(this.getName() + " currently only supports usage via " + AzureMonitorExporterBuilder.class.getName());
    }

    public String getName() {
        return "azure_monitor";
    }

    public static enum MarkerMetricExporter implements MetricExporter
    {
        INSTANCE;


        public CompletableResultCode export(Collection<MetricData> collection) {
            return CompletableResultCode.ofSuccess();
        }

        public CompletableResultCode flush() {
            return CompletableResultCode.ofSuccess();
        }

        public CompletableResultCode shutdown() {
            return CompletableResultCode.ofSuccess();
        }

        public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
            return AggregationTemporality.DELTA;
        }
    }
}

