/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation;

import com.azure.monitor.opentelemetry.exporter.implementation.Mappings;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.Trie;
import io.opentelemetry.api.common.AttributeKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MappingsBuilder {
    public static final Mappings EMPTY_MAPPINGS = new Mappings(Collections.emptyMap(), Trie.newBuilder().build());
    private static final Set<String> IGNORED_LOG_AND_SPAN_STANDARD_ATTRIBUTE_PREFIXES = new HashSet<String>(Arrays.asList("server.", "client.", "network.", "url.", "error.", "http.", "db.", "message.", "messaging.", "rpc.", "enduser.", "net.", "peer.", "exception.", "thread.", "faas.", "code.", "job.", "applicationinsights.internal."));
    private static final Set<String> IGNORED_METRIC_INTERNAL_ATTRIBUTE_PREFIXES = Collections.singleton("applicationinsights.internal.");
    private final Map<String, ExactMapping> exactMappings = new HashMap<String, ExactMapping>();
    private final Trie.Builder<PrefixMapping> prefixMappings = Trie.newBuilder();

    MappingsBuilder(MappingType mappingType) {
        switch (mappingType) {
            case LOG: 
            case SPAN: {
                for (String prefix : IGNORED_LOG_AND_SPAN_STANDARD_ATTRIBUTE_PREFIXES) {
                    this.prefixMappings.put(prefix, (telemetryBuilder, key, value) -> {});
                }
                break;
            }
            case METRIC: {
                for (String prefix : IGNORED_METRIC_INTERNAL_ATTRIBUTE_PREFIXES) {
                    this.prefixMappings.put(prefix, (telemetryBuilder, key, value) -> {});
                }
                break;
            }
        }
    }

    MappingsBuilder ignoreExact(String key) {
        this.exactMappings.put(key, (telemetryBuilder, value) -> {});
        return this;
    }

    MappingsBuilder ignorePrefix(String prefix) {
        this.prefixMappings.put(prefix, (telemetryBuilder, key, value) -> {});
        return this;
    }

    MappingsBuilder exact(String key, ExactMapping mapping) {
        this.exactMappings.put(key, mapping);
        return this;
    }

    MappingsBuilder prefix(String prefix, PrefixMapping mapping) {
        this.prefixMappings.put(prefix, mapping);
        return this;
    }

    MappingsBuilder exactString(AttributeKey<String> attributeKey, String propertyName) {
        this.exactMappings.put(attributeKey.getKey(), (telemetryBuilder, value) -> {
            if (value instanceof String) {
                telemetryBuilder.addProperty(propertyName, (String)value);
            }
        });
        return this;
    }

    MappingsBuilder exactLong(AttributeKey<Long> attributeKey, String propertyName) {
        this.exactMappings.put(attributeKey.getKey(), (telemetryBuilder, value) -> {
            if (value instanceof Long) {
                telemetryBuilder.addProperty(propertyName, Long.toString((Long)value));
            }
        });
        return this;
    }

    MappingsBuilder exactStringArray(AttributeKey<List<String>> attributeKey, String propertyName) {
        this.exactMappings.put(attributeKey.getKey(), (telemetryBuilder, value) -> {
            if (value instanceof List) {
                telemetryBuilder.addProperty(propertyName, String.join((CharSequence)",", (List)value));
            }
        });
        return this;
    }

    public Mappings build() {
        return new Mappings(this.exactMappings, this.prefixMappings.build());
    }

    static enum MappingType {
        LOG,
        SPAN,
        METRIC;

    }

    @FunctionalInterface
    static interface PrefixMapping {
        public void map(AbstractTelemetryBuilder var1, String var2, Object var3);
    }

    @FunctionalInterface
    static interface ExactMapping {
        public void map(AbstractTelemetryBuilder var1, Object var2);
    }
}

