/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.models;

import com.azure.monitor.opentelemetry.exporter.implementation.configuration.ConnectionString;
import com.azure.monitor.opentelemetry.exporter.implementation.configuration.StatsbeatConnectionString;
import com.azure.monitor.opentelemetry.exporter.implementation.models.ContextTagKeys;
import com.azure.monitor.opentelemetry.exporter.implementation.models.MonitorBase;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.opentelemetry.sdk.resources.Resource;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class TelemetryItem {
    @JsonProperty(value="ver")
    private Integer version;
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="time", required=true)
    private OffsetDateTime time;
    @JsonProperty(value="sampleRate")
    private Float sampleRate;
    @JsonProperty(value="seq")
    private String sequence;
    @JsonProperty(value="iKey")
    private String instrumentationKey;
    @JsonIgnore
    private String connectionString;
    @JsonIgnore
    private Resource resource;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="data")
    private MonitorBase data;

    public Integer getVersion() {
        return this.version;
    }

    public TelemetryItem setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public TelemetryItem setName(String name) {
        this.name = name;
        return this;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public TelemetryItem setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public Float getSampleRate() {
        return this.sampleRate;
    }

    public TelemetryItem setSampleRate(Float sampleRate) {
        this.sampleRate = sampleRate;
        return this;
    }

    public String getSequence() {
        return this.sequence;
    }

    public TelemetryItem setSequence(String sequence) {
        this.sequence = sequence;
        return this;
    }

    public String getInstrumentationKey() {
        return this.instrumentationKey;
    }

    @JsonIgnore
    public String getConnectionString() {
        return this.connectionString;
    }

    @JsonIgnore
    public TelemetryItem setConnectionString(String connectionString) {
        this.connectionString = connectionString;
        this.instrumentationKey = ConnectionString.parse(connectionString).getInstrumentationKey();
        return this;
    }

    @JsonIgnore
    public TelemetryItem setConnectionString(ConnectionString connectionString) {
        this.connectionString = connectionString.getOriginalString();
        this.instrumentationKey = connectionString.getInstrumentationKey();
        return this;
    }

    @JsonIgnore
    public TelemetryItem setConnectionString(StatsbeatConnectionString connectionString) {
        this.instrumentationKey = connectionString.getInstrumentationKey();
        this.connectionString = "InstrumentationKey=" + this.instrumentationKey + ";IngestionEndpoint=" + connectionString.getIngestionEndpoint();
        return this;
    }

    @JsonIgnore
    public Resource getResource() {
        return this.resource;
    }

    @JsonIgnore
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @JsonIgnore
    public Map<String, String> getResourceFromTags() {
        if (this.tags == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> resourceFromTags = new HashMap<String, String>();
        this.populateFromTag(ContextTagKeys.AI_CLOUD_ROLE.toString(), resourceFromTags);
        this.populateFromTag(ContextTagKeys.AI_CLOUD_ROLE_INSTANCE.toString(), resourceFromTags);
        this.populateFromTag(ContextTagKeys.AI_INTERNAL_SDK_VERSION.toString(), resourceFromTags);
        return resourceFromTags;
    }

    private void populateFromTag(String contextTagKey, Map<String, String> resourceFromTags) {
        if (this.tags == null) {
            return;
        }
        String roleName = this.tags.get(contextTagKey);
        if (roleName != null) {
            resourceFromTags.put(contextTagKey, roleName);
        }
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public TelemetryItem setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public MonitorBase getData() {
        return this.data;
    }

    public TelemetryItem setData(MonitorBase data) {
        this.data = data;
        return this;
    }
}

