/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.quickpulse;

import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseCoordinatorInitData;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseDataCollector;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseDataFetcher;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseDataSender;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulsePingSender;

final class QuickPulseCoordinatorInitDataBuilder {
    private static final long DEFAULT_WAIT_BETWEEN_PING_IN_MILLIS = 5000L;
    private static final long DEFAULT_WAIT_BETWEEN_POSTS_IN_MILLIS = 1000L;
    private static final long DEFAULT_WAIT_BETWEEN_PINGS_AFTER_ERROR_IN_MILLIS = 60000L;
    private QuickPulsePingSender pingSender;
    private QuickPulseDataSender dataSender;
    private QuickPulseDataFetcher dataFetcher;
    private QuickPulseDataCollector collector;
    private long waitBetweenPingsInMillis = 5000L;
    private long waitBetweenPostsInMillis = 1000L;
    private long waitOnErrorInMillis = 60000L;

    QuickPulseCoordinatorInitDataBuilder() {
    }

    QuickPulseCoordinatorInitDataBuilder withWaitBetweenPingsInMillis(long waitBetweenPingsInMillis) {
        this.waitBetweenPingsInMillis = waitBetweenPingsInMillis;
        return this;
    }

    QuickPulseCoordinatorInitDataBuilder withWaitBetweenPostsInMillis(long waitBetweenPostsInMillis) {
        this.waitBetweenPostsInMillis = waitBetweenPostsInMillis;
        return this;
    }

    QuickPulseCoordinatorInitDataBuilder withWaitOnErrorInMillis(long waitOnErrorInMillis) {
        this.waitOnErrorInMillis = waitOnErrorInMillis;
        return this;
    }

    QuickPulseCoordinatorInitDataBuilder withPingSender(QuickPulsePingSender pingSender) {
        this.pingSender = pingSender;
        return this;
    }

    QuickPulseCoordinatorInitDataBuilder withDataSender(QuickPulseDataSender dataSender) {
        this.dataSender = dataSender;
        return this;
    }

    QuickPulseCoordinatorInitDataBuilder withDataFetcher(QuickPulseDataFetcher dataFetcher) {
        this.dataFetcher = dataFetcher;
        return this;
    }

    QuickPulseCoordinatorInitDataBuilder withCollector(QuickPulseDataCollector collector) {
        this.collector = collector;
        return this;
    }

    QuickPulseCoordinatorInitData build() {
        if (this.pingSender == null) {
            throw new NullPointerException("ping sender should not be null");
        }
        if (this.dataFetcher == null) {
            throw new NullPointerException("data fetcher should not be null");
        }
        if (this.dataSender == null) {
            throw new NullPointerException("data sender should not be null");
        }
        return new QuickPulseCoordinatorInitData(this.pingSender, this.dataFetcher, this.dataSender, this.collector, this.waitBetweenPingsInMillis, this.waitBetweenPostsInMillis, this.waitOnErrorInMillis);
    }
}

