/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.utils;

import com.azure.core.util.CoreUtils;
import java.util.Map;

public final class VersionGenerator {
    private static final String UNKNOWN_VERSION_VALUE = "unknown";
    private static final String artifactName;
    private static final String artifactVersion;
    private static final String sdkVersionString;

    public static String getArtifactName() {
        return artifactName;
    }

    public static String getArtifactVersion() {
        return artifactVersion;
    }

    public static String getSdkVersion() {
        return sdkVersionString;
    }

    private static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    private static String getOpenTelemetryApiVersion() {
        Map properties = CoreUtils.getProperties((String)"io/opentelemetry/api/version.properties");
        if (properties == null) {
            return UNKNOWN_VERSION_VALUE;
        }
        String version = (String)properties.get("sdk.version");
        return version != null ? version : UNKNOWN_VERSION_VALUE;
    }

    private VersionGenerator() {
    }

    static {
        Map properties = CoreUtils.getProperties((String)"azure-monitor-opentelemetry-exporter.properties");
        artifactName = (String)properties.get("name");
        artifactVersion = (String)properties.get("version");
        sdkVersionString = "java" + VersionGenerator.getJavaVersion() + ":otel" + VersionGenerator.getOpenTelemetryApiVersion() + ":ext" + artifactVersion;
    }
}

