/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation;

import com.azure.monitor.opentelemetry.exporter.implementation.AiSemanticAttributes;
import com.azure.monitor.opentelemetry.exporter.implementation.Mappings;
import com.azure.monitor.opentelemetry.exporter.implementation.MappingsBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.RequestChecker;
import com.azure.monitor.opentelemetry.exporter.implementation.SemanticAttributes;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.ExceptionTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.Exceptions;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.MessageTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.RemoteDependencyTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.RequestTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.configuration.ConnectionString;
import com.azure.monitor.opentelemetry.exporter.implementation.logging.WarningLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.models.ContextTagKeys;
import com.azure.monitor.opentelemetry.exporter.implementation.models.TelemetryItem;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.FormattedDuration;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.FormattedTime;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.UrlParser;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import reactor.util.annotation.Nullable;

public final class SpanDataMapper {
    public static final String MS_PROCESSED_BY_METRIC_EXTRACTORS = "_MS.ProcessedByMetricExtractors";
    private static final Set<String> SQL_DB_SYSTEMS = new HashSet<String>(Arrays.asList("db2", "derby", "mariadb", "mssql", "mysql", "oracle", "postgresql", "sqlite", "other_sql", "hsqldb", "h2"));
    private static final String COSMOS = "Cosmos";
    private static final Mappings MAPPINGS;
    private static final ContextTagKeys AI_DEVICE_OS;
    private final boolean captureHttpServer4xxAsError;
    private final BiConsumer<AbstractTelemetryBuilder, Resource> telemetryInitializer;
    private final BiPredicate<EventData, String> eventSuppressor;
    private final BiPredicate<SpanData, EventData> shouldSuppress;
    private static final Set<String> DEFAULT_HTTP_SPAN_NAMES;
    private static final WarningLogger connectionStringAttributeNoLongerSupported;
    private static final WarningLogger roleNameAttributeNoLongerSupported;
    private static final WarningLogger roleInstanceAttributeNoLongerSupported;
    private static final WarningLogger instrumentationKeyAttributeNoLongerSupported;

    public SpanDataMapper(boolean captureHttpServer4xxAsError, BiConsumer<AbstractTelemetryBuilder, Resource> telemetryInitializer, BiPredicate<EventData, String> eventSuppressor, BiPredicate<SpanData, EventData> shouldSuppress) {
        this.captureHttpServer4xxAsError = captureHttpServer4xxAsError;
        this.telemetryInitializer = telemetryInitializer;
        this.eventSuppressor = eventSuppressor;
        this.shouldSuppress = shouldSuppress;
    }

    public TelemetryItem map(SpanData span) {
        Double sampleRate = SpanDataMapper.getSampleRate(span);
        return this.map(span, sampleRate);
    }

    public void map(SpanData span, Consumer<TelemetryItem> consumer) {
        Double sampleRate = SpanDataMapper.getSampleRate(span);
        TelemetryItem telemetryItem = this.map(span, sampleRate);
        consumer.accept(telemetryItem);
        this.exportEvents(span, telemetryItem.getTags().get(ContextTagKeys.AI_OPERATION_NAME.toString()), sampleRate, consumer);
    }

    public TelemetryItem map(SpanData span, @Nullable Double sampleRate) {
        if (RequestChecker.isRequest(span)) {
            return this.exportRequest(span, sampleRate);
        }
        return this.exportRemoteDependency(span, span.getKind() == SpanKind.INTERNAL, sampleRate);
    }

    private static boolean checkIsPreAggregatedStandardMetric(SpanData span) {
        Boolean isPreAggregatedStandardMetric = (Boolean)span.getAttributes().get(AiSemanticAttributes.IS_PRE_AGGREGATED);
        return isPreAggregatedStandardMetric != null && isPreAggregatedStandardMetric != false;
    }

    private TelemetryItem exportRemoteDependency(SpanData span, boolean inProc, @Nullable Double sampleRate) {
        RemoteDependencyTelemetryBuilder telemetryBuilder = RemoteDependencyTelemetryBuilder.create();
        this.telemetryInitializer.accept(telemetryBuilder, span.getResource());
        SpanDataMapper.setOperationTags(telemetryBuilder, span);
        SpanDataMapper.setTime(telemetryBuilder, span.getStartEpochNanos());
        SpanDataMapper.setSampleRate(telemetryBuilder, sampleRate);
        MAPPINGS.map(span.getAttributes(), telemetryBuilder);
        SpanDataMapper.addLinks(telemetryBuilder, span.getLinks());
        telemetryBuilder.setId(span.getSpanId());
        telemetryBuilder.setName(SpanDataMapper.getDependencyName(span));
        telemetryBuilder.setDuration(FormattedDuration.fromNanos(span.getEndEpochNanos() - span.getStartEpochNanos()));
        telemetryBuilder.setSuccess(this.getSuccess(span));
        if (inProc) {
            telemetryBuilder.setType("InProc");
        } else {
            SpanDataMapper.applySemanticConventions(telemetryBuilder, span);
        }
        if (SpanDataMapper.checkIsPreAggregatedStandardMetric(span)) {
            telemetryBuilder.addProperty(MS_PROCESSED_BY_METRIC_EXTRACTORS, "True");
        }
        return telemetryBuilder.build();
    }

    private static String getDependencyName(SpanData span) {
        String name = span.getName();
        String method = SpanDataMapper.getStableOrOldAttribute(span.getAttributes(), SemanticAttributes.HTTP_REQUEST_METHOD, SemanticAttributes.HTTP_METHOD);
        if (method == null) {
            return name;
        }
        if (!DEFAULT_HTTP_SPAN_NAMES.contains(name)) {
            return name;
        }
        String url = SpanDataMapper.getStableOrOldAttribute(span.getAttributes(), SemanticAttributes.URL_FULL, SemanticAttributes.HTTP_URL);
        if (url == null) {
            return name;
        }
        String path = UrlParser.getPath(url);
        if (path == null) {
            return name;
        }
        return path.isEmpty() ? method + " /" : method + " " + path;
    }

    private static void applySemanticConventions(RemoteDependencyTelemetryBuilder telemetryBuilder, SpanData span) {
        Attributes attributes = span.getAttributes();
        String httpMethod = SpanDataMapper.getStableOrOldAttribute(attributes, SemanticAttributes.HTTP_REQUEST_METHOD, SemanticAttributes.HTTP_METHOD);
        if (httpMethod != null) {
            SpanDataMapper.applyHttpClientSpan(telemetryBuilder, attributes);
            return;
        }
        String rpcSystem = (String)attributes.get(SemanticAttributes.RPC_SYSTEM);
        if (rpcSystem != null) {
            SpanDataMapper.applyRpcClientSpan(telemetryBuilder, rpcSystem, attributes);
            return;
        }
        String dbSystem = (String)attributes.get(SemanticAttributes.DB_SYSTEM);
        if (dbSystem == null) {
            dbSystem = (String)attributes.get(AiSemanticAttributes.AZURE_SDK_DB_TYPE);
        }
        if (dbSystem != null) {
            SpanDataMapper.applyDatabaseClientSpan(telemetryBuilder, dbSystem, attributes);
            return;
        }
        String messagingSystem = SpanDataMapper.getMessagingSystem(attributes);
        if (messagingSystem != null) {
            SpanDataMapper.applyMessagingClientSpan(telemetryBuilder, span.getKind(), messagingSystem, attributes);
            return;
        }
        String target = SpanDataMapper.getTargetOrDefault(attributes, Integer.MAX_VALUE, null);
        if (target != null) {
            telemetryBuilder.setTarget(target);
            return;
        }
        telemetryBuilder.setType("InProc");
    }

    @Nullable
    private static String getMessagingSystem(Attributes attributes) {
        String azureNamespace = (String)attributes.get(AiSemanticAttributes.AZURE_SDK_NAMESPACE);
        if (SpanDataMapper.isAzureSdkMessaging(azureNamespace)) {
            return azureNamespace;
        }
        return (String)attributes.get(SemanticAttributes.MESSAGING_SYSTEM);
    }

    private static void setOperationTags(AbstractTelemetryBuilder telemetryBuilder, SpanData span) {
        SpanDataMapper.setOperationId(telemetryBuilder, span.getTraceId());
        SpanDataMapper.setOperationParentId(telemetryBuilder, span.getParentSpanContext().getSpanId());
        SpanDataMapper.setOperationName(telemetryBuilder, span.getAttributes());
    }

    private static void setOperationId(AbstractTelemetryBuilder telemetryBuilder, String traceId) {
        telemetryBuilder.addTag(ContextTagKeys.AI_OPERATION_ID.toString(), traceId);
    }

    private static void setOperationParentId(AbstractTelemetryBuilder telemetryBuilder, String parentSpanId) {
        if (SpanId.isValid((CharSequence)parentSpanId)) {
            telemetryBuilder.addTag(ContextTagKeys.AI_OPERATION_PARENT_ID.toString(), parentSpanId);
        }
    }

    private static void setOperationName(AbstractTelemetryBuilder telemetryBuilder, Attributes attributes) {
        String operationName = (String)attributes.get(AiSemanticAttributes.OPERATION_NAME);
        if (operationName != null) {
            SpanDataMapper.setOperationName(telemetryBuilder, operationName);
        }
    }

    private static void setOperationName(AbstractTelemetryBuilder telemetryBuilder, String operationName) {
        telemetryBuilder.addTag(ContextTagKeys.AI_OPERATION_NAME.toString(), operationName);
    }

    private static void applyHttpClientSpan(RemoteDependencyTelemetryBuilder telemetryBuilder, Attributes attributes) {
        String httpUrl = SpanDataMapper.getStableOrOldAttribute(attributes, SemanticAttributes.URL_FULL, SemanticAttributes.HTTP_URL);
        int defaultPort = SpanDataMapper.getDefaultPortForHttpUrl(httpUrl);
        String target = SpanDataMapper.getTargetOrDefault(attributes, defaultPort, "Http");
        telemetryBuilder.setType("Http");
        telemetryBuilder.setTarget(target);
        Long httpStatusCode = SpanDataMapper.getStableOrOldAttribute(attributes, SemanticAttributes.HTTP_RESPONSE_STATUS_CODE, SemanticAttributes.HTTP_STATUS_CODE);
        if (httpStatusCode != null) {
            telemetryBuilder.setResultCode(Long.toString(httpStatusCode));
        } else {
            telemetryBuilder.setResultCode("0");
        }
        telemetryBuilder.setData(httpUrl);
    }

    private static void applyRpcClientSpan(RemoteDependencyTelemetryBuilder telemetryBuilder, String rpcSystem, Attributes attributes) {
        telemetryBuilder.setType(rpcSystem);
        String target = SpanDataMapper.getTargetOrDefault(attributes, Integer.MAX_VALUE, rpcSystem);
        telemetryBuilder.setTarget(target);
    }

    private static int getDefaultPortForHttpUrl(@Nullable String httpUrl) {
        if (httpUrl == null) {
            return Integer.MAX_VALUE;
        }
        if (httpUrl.startsWith("https://")) {
            return 443;
        }
        if (httpUrl.startsWith("http://")) {
            return 80;
        }
        return Integer.MAX_VALUE;
    }

    public static String getTargetOrDefault(Attributes attributes, int defaultPort, String defaultTarget) {
        String target = SpanDataMapper.getTargetOrNullStableSemconv(attributes, defaultPort);
        if (target != null) {
            return target;
        }
        target = SpanDataMapper.getTargetOrNullOldSemconv(attributes, defaultPort);
        if (target != null) {
            return target;
        }
        return defaultTarget;
    }

    @Nullable
    private static String getTargetOrNullStableSemconv(Attributes attributes, int defaultPort) {
        String peerService = (String)attributes.get(SemanticAttributes.PEER_SERVICE);
        if (peerService != null) {
            return peerService;
        }
        String host = (String)attributes.get(SemanticAttributes.SERVER_ADDRESS);
        if (host != null) {
            Long port = (Long)attributes.get(SemanticAttributes.SERVER_PORT);
            return SpanDataMapper.getTarget(host, port, defaultPort);
        }
        return null;
    }

    @Nullable
    private static String getTargetOrNullOldSemconv(Attributes attributes, int defaultPort) {
        String peerService = (String)attributes.get(SemanticAttributes.PEER_SERVICE);
        if (peerService != null) {
            return peerService;
        }
        String host = (String)attributes.get(SemanticAttributes.NET_PEER_NAME);
        if (host != null) {
            Long port = (Long)attributes.get(SemanticAttributes.NET_PEER_PORT);
            return SpanDataMapper.getTarget(host, port, defaultPort);
        }
        host = (String)attributes.get(SemanticAttributes.NET_SOCK_PEER_NAME);
        if (host == null) {
            host = (String)attributes.get(SemanticAttributes.NET_SOCK_PEER_ADDR);
        }
        if (host != null) {
            Long port = (Long)attributes.get(SemanticAttributes.NET_SOCK_PEER_PORT);
            return SpanDataMapper.getTarget(host, port, defaultPort);
        }
        String httpUrl = (String)attributes.get(SemanticAttributes.HTTP_URL);
        if (httpUrl != null) {
            return UrlParser.getTarget(httpUrl);
        }
        return null;
    }

    private static String getTarget(String host, @Nullable Long port, int defaultPort) {
        if (port != null && port != (long)defaultPort) {
            return host + ":" + port;
        }
        return host;
    }

    private static void applyDatabaseClientSpan(RemoteDependencyTelemetryBuilder telemetryBuilder, String dbSystem, Attributes attributes) {
        String dbName;
        String target;
        String dbStatement = (String)attributes.get(SemanticAttributes.DB_STATEMENT);
        if (dbStatement == null) {
            dbStatement = (String)attributes.get(SemanticAttributes.DB_OPERATION);
        }
        String type = SQL_DB_SYSTEMS.contains(dbSystem) ? (dbSystem.equals("mysql") ? "mysql" : (dbSystem.equals("postgresql") ? "postgresql" : "SQL")) : (dbSystem.equals(COSMOS) ? "Microsoft.DocumentDb" : dbSystem);
        telemetryBuilder.setType(type);
        telemetryBuilder.setData(dbStatement);
        if (dbSystem.equals(COSMOS)) {
            String dbUrl = (String)attributes.get(AiSemanticAttributes.AZURE_SDK_DB_URL);
            target = dbUrl != null ? UrlParser.getTarget(dbUrl) : null;
            dbName = (String)attributes.get(AiSemanticAttributes.AZURE_SDK_DB_INSTANCE);
        } else {
            target = SpanDataMapper.getTargetOrDefault(attributes, SpanDataMapper.getDefaultPortForDbSystem(dbSystem), dbSystem);
            dbName = (String)attributes.get(SemanticAttributes.DB_NAME);
        }
        target = SpanDataMapper.nullAwareConcat(target, dbName, " | ");
        if (target == null) {
            target = dbSystem;
        }
        telemetryBuilder.setTarget(target);
    }

    private static void applyMessagingClientSpan(RemoteDependencyTelemetryBuilder telemetryBuilder, SpanKind spanKind, String messagingSystem, Attributes attributes) {
        if (spanKind == SpanKind.PRODUCER) {
            telemetryBuilder.setType("Queue Message | " + messagingSystem);
        } else {
            telemetryBuilder.setType(messagingSystem);
        }
        telemetryBuilder.setTarget(SpanDataMapper.getMessagingTargetSource(attributes));
    }

    private static int getDefaultPortForDbSystem(String dbSystem) {
        switch (dbSystem) {
            case "mongodb": {
                return 27017;
            }
            case "cassandra": {
                return 9042;
            }
            case "redis": {
                return 6379;
            }
            case "mariadb": 
            case "mysql": {
                return 3306;
            }
            case "mssql": {
                return 1433;
            }
            case "db2": {
                return 50000;
            }
            case "oracle": {
                return 1521;
            }
            case "h2": {
                return 8082;
            }
            case "derby": {
                return 1527;
            }
            case "postgresql": {
                return 5432;
            }
        }
        return Integer.MAX_VALUE;
    }

    private TelemetryItem exportRequest(SpanData span, @Nullable Double sampleRate) {
        Long timeSinceEnqueuedMillis;
        Long enqueuedTime;
        String deviceOsVersion;
        String deviceOs;
        Long httpStatusCode;
        RequestTelemetryBuilder telemetryBuilder = RequestTelemetryBuilder.create();
        this.telemetryInitializer.accept(telemetryBuilder, span.getResource());
        Attributes attributes = span.getAttributes();
        long startEpochNanos = span.getStartEpochNanos();
        telemetryBuilder.setId(span.getSpanId());
        SpanDataMapper.setTime(telemetryBuilder, startEpochNanos);
        SpanDataMapper.setSampleRate(telemetryBuilder, sampleRate);
        MAPPINGS.map(attributes, telemetryBuilder);
        SpanDataMapper.addLinks(telemetryBuilder, span.getLinks());
        String operationName = SpanDataMapper.getOperationName(span);
        telemetryBuilder.addTag(ContextTagKeys.AI_OPERATION_NAME.toString(), operationName);
        telemetryBuilder.addTag(ContextTagKeys.AI_OPERATION_ID.toString(), span.getTraceId());
        String aiLegacyParentId = (String)span.getAttributes().get(AiSemanticAttributes.LEGACY_PARENT_ID);
        if (aiLegacyParentId != null) {
            telemetryBuilder.addTag(ContextTagKeys.AI_OPERATION_PARENT_ID.toString(), aiLegacyParentId);
        } else if (span.getParentSpanContext().isValid()) {
            telemetryBuilder.addTag(ContextTagKeys.AI_OPERATION_PARENT_ID.toString(), span.getParentSpanContext().getSpanId());
        }
        String aiLegacyRootId = (String)span.getAttributes().get(AiSemanticAttributes.LEGACY_ROOT_ID);
        if (aiLegacyRootId != null) {
            telemetryBuilder.addTag("ai_legacyRootID", aiLegacyRootId);
        }
        telemetryBuilder.setName(operationName);
        telemetryBuilder.setDuration(FormattedDuration.fromNanos(span.getEndEpochNanos() - startEpochNanos));
        telemetryBuilder.setSuccess(this.getSuccess(span));
        String httpUrl = SpanDataMapper.getHttpUrlFromServerSpan(attributes);
        if (httpUrl != null) {
            telemetryBuilder.setUrl(httpUrl);
        }
        if ((httpStatusCode = SpanDataMapper.getStableOrOldAttribute(attributes, SemanticAttributes.HTTP_RESPONSE_STATUS_CODE, SemanticAttributes.HTTP_STATUS_CODE)) == null) {
            httpStatusCode = (Long)attributes.get(SemanticAttributes.RPC_GRPC_STATUS_CODE);
        }
        if (httpStatusCode != null) {
            telemetryBuilder.setResponseCode(Long.toString(httpStatusCode));
        } else {
            telemetryBuilder.setResponseCode("0");
        }
        String locationIp = SpanDataMapper.getStableOrOldAttribute(attributes, SemanticAttributes.CLIENT_ADDRESS, SemanticAttributes.HTTP_CLIENT_IP);
        if (locationIp == null) {
            locationIp = (String)attributes.get(SemanticAttributes.NET_SOCK_PEER_ADDR);
        }
        if (locationIp != null) {
            telemetryBuilder.addTag(ContextTagKeys.AI_LOCATION_IP.toString(), locationIp);
        }
        telemetryBuilder.setSource(SpanDataMapper.getSource(attributes));
        String sessionId = (String)attributes.get(AiSemanticAttributes.SESSION_ID);
        if (sessionId != null) {
            telemetryBuilder.addTag(ContextTagKeys.AI_SESSION_ID.toString(), sessionId);
        }
        if ((deviceOs = (String)attributes.get(AiSemanticAttributes.DEVICE_OS)) != null) {
            telemetryBuilder.addTag(AI_DEVICE_OS.toString(), deviceOs);
        }
        if ((deviceOsVersion = (String)attributes.get(AiSemanticAttributes.DEVICE_OS_VERSION)) != null) {
            telemetryBuilder.addTag(ContextTagKeys.AI_DEVICE_OS_VERSION.toString(), deviceOsVersion);
        }
        if (SpanDataMapper.checkIsPreAggregatedStandardMetric(span)) {
            telemetryBuilder.addProperty(MS_PROCESSED_BY_METRIC_EXTRACTORS, "True");
        }
        if ((enqueuedTime = (Long)attributes.get(AiSemanticAttributes.AZURE_SDK_ENQUEUED_TIME)) != null) {
            long timeSinceEnqueuedMillis2 = Math.max(0L, TimeUnit.NANOSECONDS.toMillis(span.getStartEpochNanos()) - TimeUnit.SECONDS.toMillis(enqueuedTime));
            telemetryBuilder.addMeasurement("timeSinceEnqueued", Double.valueOf(timeSinceEnqueuedMillis2));
        }
        if ((timeSinceEnqueuedMillis = (Long)attributes.get(AiSemanticAttributes.KAFKA_RECORD_QUEUE_TIME_MS)) != null) {
            telemetryBuilder.addMeasurement("timeSinceEnqueued", (double)timeSinceEnqueuedMillis);
        }
        return telemetryBuilder.build();
    }

    private boolean getSuccess(SpanData span) {
        switch (span.getStatus().getStatusCode()) {
            case ERROR: {
                return false;
            }
            case OK: {
                return true;
            }
            case UNSET: {
                if (this.captureHttpServer4xxAsError) {
                    Long statusCode = SpanDataMapper.getStableOrOldAttribute(span.getAttributes(), SemanticAttributes.HTTP_RESPONSE_STATUS_CODE, SemanticAttributes.HTTP_STATUS_CODE);
                    return statusCode == null || statusCode < 400L;
                }
                return true;
            }
        }
        return true;
    }

    @Nullable
    public static String getHttpUrlFromServerSpan(Attributes attributes) {
        String httpUrl = SpanDataMapper.getHttpUrlFromServerSpanStableSemconv(attributes);
        if (httpUrl != null) {
            return httpUrl;
        }
        return SpanDataMapper.getHttpUrlFromServerSpanOldSemconv(attributes);
    }

    @Nullable
    private static String getHttpUrlFromServerSpanStableSemconv(Attributes attributes) {
        String scheme = (String)attributes.get(SemanticAttributes.URL_SCHEME);
        if (scheme == null) {
            return null;
        }
        String host = (String)attributes.get(SemanticAttributes.SERVER_ADDRESS);
        if (host == null) {
            return null;
        }
        Long port = (Long)attributes.get(SemanticAttributes.SERVER_PORT);
        String path = (String)attributes.get(SemanticAttributes.URL_PATH);
        if (path == null) {
            return null;
        }
        String query = (String)attributes.get(SemanticAttributes.URL_QUERY);
        int len = scheme.length() + host.length() + path.length();
        if (port != null) {
            len += 6;
        }
        if (query != null) {
            len += query.length() + 1;
        }
        StringBuilder sb = new StringBuilder(len);
        sb.append(scheme);
        sb.append("://");
        sb.append(host);
        if (port != null && port > 0L && !SpanDataMapper.isDefaultPortForScheme(port, scheme)) {
            sb.append(':');
            sb.append(port);
        }
        sb.append(path);
        if (query != null) {
            sb.append('?');
            sb.append(query);
        }
        return sb.toString();
    }

    private static boolean isDefaultPortForScheme(Long port, String scheme) {
        return port == 80L && scheme.equals("http") || port == 443L && scheme.equals("https");
    }

    @Nullable
    private static String getHttpUrlFromServerSpanOldSemconv(Attributes attributes) {
        String httpUrl = (String)attributes.get(SemanticAttributes.HTTP_URL);
        if (httpUrl != null) {
            return httpUrl;
        }
        String scheme = (String)attributes.get(SemanticAttributes.HTTP_SCHEME);
        if (scheme == null) {
            return null;
        }
        String target = (String)attributes.get(SemanticAttributes.HTTP_TARGET);
        if (target == null) {
            return null;
        }
        String host = (String)attributes.get(SemanticAttributes.NET_HOST_NAME);
        Long port = (Long)attributes.get(SemanticAttributes.NET_HOST_PORT);
        if (port != null && port > 0L) {
            return scheme + "://" + host + ":" + port + target;
        }
        return scheme + "://" + host + target;
    }

    @Nullable
    private static String getSource(Attributes attributes) {
        String source = (String)attributes.get(AiSemanticAttributes.SPAN_SOURCE);
        if (source != null) {
            return source;
        }
        return SpanDataMapper.getMessagingTargetSource(attributes);
    }

    @Nullable
    private static String getMessagingTargetSource(Attributes attributes) {
        String peerAddress;
        if (SpanDataMapper.isAzureSdkMessaging((String)attributes.get(AiSemanticAttributes.AZURE_SDK_NAMESPACE)) && (peerAddress = (String)attributes.get(AiSemanticAttributes.AZURE_SDK_PEER_ADDRESS)) != null) {
            String destination = (String)attributes.get(AiSemanticAttributes.AZURE_SDK_MESSAGE_BUS_DESTINATION);
            return peerAddress + "/" + destination;
        }
        String messagingSystem = SpanDataMapper.getMessagingSystem(attributes);
        if (messagingSystem == null) {
            return null;
        }
        String source = SpanDataMapper.nullAwareConcat(SpanDataMapper.getTargetOrNullOldSemconv(attributes, Integer.MAX_VALUE), (String)attributes.get(SemanticAttributes.MESSAGING_DESTINATION_NAME), "/");
        if (source != null) {
            return source;
        }
        return messagingSystem;
    }

    private static boolean isAzureSdkMessaging(String messagingSystem) {
        return "Microsoft.EventHub".equals(messagingSystem) || "Microsoft.ServiceBus".equals(messagingSystem);
    }

    private static String getOperationName(SpanData span) {
        String operationName = (String)span.getAttributes().get(AiSemanticAttributes.OPERATION_NAME);
        if (operationName != null) {
            return operationName;
        }
        return span.getName();
    }

    private static String nullAwareConcat(@Nullable String str1, @Nullable String str2, String separator) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        return str1 + separator + str2;
    }

    private void exportEvents(SpanData span, @Nullable String operationName, @Nullable Double sampleRate, Consumer<TelemetryItem> consumer) {
        for (EventData event : span.getEvents()) {
            String instrumentationScopeName;
            if (this.eventSuppressor.test(event, instrumentationScopeName = span.getInstrumentationScopeInfo().getName())) continue;
            if (event.getAttributes().get(SemanticAttributes.EXCEPTION_TYPE) != null || event.getAttributes().get(SemanticAttributes.EXCEPTION_MESSAGE) != null) {
                String exceptionLogged;
                String stacktrace;
                SpanContext parentSpanContext = span.getParentSpanContext();
                if (!(parentSpanContext.isValid() && !parentSpanContext.isRemote() || (stacktrace = (String)event.getAttributes().get(SemanticAttributes.EXCEPTION_STACKTRACE)) == null || this.shouldSuppress.test(span, event) || stacktrace.equals(exceptionLogged = (String)span.getAttributes().get(AiSemanticAttributes.LOGGED_EXCEPTION)))) {
                    consumer.accept(this.createExceptionTelemetryItem((String)event.getAttributes().get(SemanticAttributes.EXCEPTION_STACKTRACE), span, operationName, sampleRate));
                }
                return;
            }
            MessageTelemetryBuilder telemetryBuilder = MessageTelemetryBuilder.create();
            this.telemetryInitializer.accept(telemetryBuilder, span.getResource());
            SpanDataMapper.setOperationId(telemetryBuilder, span.getTraceId());
            SpanDataMapper.setOperationParentId(telemetryBuilder, span.getSpanId());
            if (operationName != null) {
                SpanDataMapper.setOperationName((AbstractTelemetryBuilder)telemetryBuilder, operationName);
            } else {
                SpanDataMapper.setOperationName((AbstractTelemetryBuilder)telemetryBuilder, span.getAttributes());
            }
            SpanDataMapper.setTime(telemetryBuilder, event.getEpochNanos());
            SpanDataMapper.setSampleRate(telemetryBuilder, sampleRate);
            MAPPINGS.map(event.getAttributes(), telemetryBuilder);
            telemetryBuilder.setMessage(event.getName());
            consumer.accept(telemetryBuilder.build());
        }
    }

    private TelemetryItem createExceptionTelemetryItem(String errorStack, SpanData span, @Nullable String operationName, @Nullable Double sampleRate) {
        ExceptionTelemetryBuilder telemetryBuilder = ExceptionTelemetryBuilder.create();
        this.telemetryInitializer.accept(telemetryBuilder, span.getResource());
        SpanDataMapper.setOperationId(telemetryBuilder, span.getTraceId());
        SpanDataMapper.setOperationParentId(telemetryBuilder, span.getSpanId());
        if (operationName != null) {
            SpanDataMapper.setOperationName((AbstractTelemetryBuilder)telemetryBuilder, operationName);
        } else {
            SpanDataMapper.setOperationName((AbstractTelemetryBuilder)telemetryBuilder, span.getAttributes());
        }
        SpanDataMapper.setTime(telemetryBuilder, span.getEndEpochNanos());
        SpanDataMapper.setSampleRate(telemetryBuilder, sampleRate);
        MAPPINGS.map(span.getAttributes(), telemetryBuilder);
        telemetryBuilder.setExceptions(Exceptions.minimalParse(errorStack));
        return telemetryBuilder.build();
    }

    public static <T> T getStableOrOldAttribute(Attributes attributes, AttributeKey<T> stable, AttributeKey<T> old) {
        Object value = attributes.get(stable);
        if (value != null) {
            return (T)value;
        }
        return (T)attributes.get(old);
    }

    private static void setTime(AbstractTelemetryBuilder telemetryBuilder, long epochNanos) {
        telemetryBuilder.setTime(FormattedTime.offSetDateTimeFromEpochNanos(epochNanos));
    }

    private static void setSampleRate(AbstractTelemetryBuilder telemetryBuilder, @Nullable Double sampleRate) {
        if (sampleRate != null) {
            telemetryBuilder.setSampleRate(sampleRate.floatValue());
        }
    }

    @Nullable
    private static Double getSampleRate(SpanData span) {
        return (Double)span.getAttributes().get(AiSemanticAttributes.SAMPLE_RATE);
    }

    private static void addLinks(AbstractTelemetryBuilder telemetryBuilder, List<LinkData> links) {
        if (links.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (LinkData link : links) {
            if (!first) {
                sb.append(",");
            }
            sb.append("{\"operation_Id\":\"");
            sb.append(link.getSpanContext().getTraceId());
            sb.append("\",\"id\":\"");
            sb.append(link.getSpanContext().getSpanId());
            sb.append("\"}");
            first = false;
        }
        sb.append("]");
        telemetryBuilder.addProperty("_MS.links", sb.toString());
    }

    static void applyCommonTags(MappingsBuilder mappingsBuilder) {
        mappingsBuilder.exact(SemanticAttributes.ENDUSER_ID.getKey(), (telemetryBuilder, value) -> {
            if (value instanceof String) {
                telemetryBuilder.addTag(ContextTagKeys.AI_USER_ID.toString(), (String)value);
            }
        }).exact(AiSemanticAttributes.PREVIEW_APPLICATION_VERSION.getKey(), (telemetryBuilder, value) -> {
            if (value instanceof String) {
                telemetryBuilder.addTag(ContextTagKeys.AI_APPLICATION_VER.toString(), (String)value);
            }
        });
        SpanDataMapper.applyConnectionStringAndRoleNameOverrides(mappingsBuilder);
    }

    static void applyConnectionStringAndRoleNameOverrides(MappingsBuilder mappingsBuilder) {
        mappingsBuilder.exact(AiSemanticAttributes.INTERNAL_CONNECTION_STRING.getKey(), (telemetryBuilder, value) -> telemetryBuilder.setConnectionString(ConnectionString.parse((String)value))).exact(AiSemanticAttributes.INTERNAL_ROLE_NAME.getKey(), (telemetryBuilder, value) -> {
            if (value instanceof String) {
                telemetryBuilder.addTag(ContextTagKeys.AI_CLOUD_ROLE.toString(), (String)value);
            }
        }).exact(AiSemanticAttributes.DEPRECATED_CONNECTION_STRING.getKey(), (telemetryBuilder, value) -> connectionStringAttributeNoLongerSupported.recordWarning()).exact(AiSemanticAttributes.DEPRECATED_ROLE_NAME.getKey(), (telemetryBuilder, value) -> roleNameAttributeNoLongerSupported.recordWarning()).exact(AiSemanticAttributes.DEPRECATED_ROLE_INSTANCE.getKey(), (telemetryBuilder, value) -> roleInstanceAttributeNoLongerSupported.recordWarning()).exact(AiSemanticAttributes.DEPRECATED_INSTRUMENTATION_KEY.getKey(), (telemetryBuilder, value) -> instrumentationKeyAttributeNoLongerSupported.recordWarning());
    }

    static {
        AI_DEVICE_OS = ContextTagKeys.fromString("ai.device.os");
        MappingsBuilder mappingsBuilder = new MappingsBuilder(MappingsBuilder.MappingType.SPAN).ignoreExact(AiSemanticAttributes.AZURE_SDK_NAMESPACE.getKey()).ignoreExact(AiSemanticAttributes.AZURE_SDK_MESSAGE_BUS_DESTINATION.getKey()).ignoreExact(AiSemanticAttributes.AZURE_SDK_ENQUEUED_TIME.getKey()).ignoreExact(AiSemanticAttributes.KAFKA_RECORD_QUEUE_TIME_MS.getKey()).ignoreExact(AiSemanticAttributes.KAFKA_OFFSET.getKey()).exact(SemanticAttributes.USER_AGENT_ORIGINAL.getKey(), (builder, value) -> {
            if (value instanceof String) {
                builder.addTag("ai.user.userAgent", (String)value);
            }
        }).ignorePrefix("applicationinsights.internal.").prefix("http.request.header.", (telemetryBuilder, key, value) -> {
            if (value instanceof List) {
                telemetryBuilder.addProperty(key, Mappings.join((List)value));
            }
        }).prefix("http.response.header.", (telemetryBuilder, key, value) -> {
            if (value instanceof List) {
                telemetryBuilder.addProperty(key, Mappings.join((List)value));
            }
        });
        SpanDataMapper.applyCommonTags(mappingsBuilder);
        MAPPINGS = mappingsBuilder.build();
        DEFAULT_HTTP_SPAN_NAMES = new HashSet<String>(Arrays.asList("OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "CONNECT", "PATCH"));
        connectionStringAttributeNoLongerSupported = new WarningLogger(SpanDataMapper.class, AiSemanticAttributes.DEPRECATED_CONNECTION_STRING.getKey() + " is no longer supported because it is incompatible with pre-aggregated standard metrics. Please use \"connectionStringOverrides\" configuration, or reach out to https://github.com/microsoft/ApplicationInsights-Java/issues if you have a different use case.");
        roleNameAttributeNoLongerSupported = new WarningLogger(SpanDataMapper.class, AiSemanticAttributes.DEPRECATED_ROLE_NAME.getKey() + " is no longer supported because it is incompatible with pre-aggregated standard metrics. Please use \"roleNameOverrides\" configuration, or reach out to https://github.com/microsoft/ApplicationInsights-Java/issues if you have a different use case.");
        roleInstanceAttributeNoLongerSupported = new WarningLogger(SpanDataMapper.class, AiSemanticAttributes.DEPRECATED_ROLE_INSTANCE.getKey() + " is no longer supported because it is incompatible with pre-aggregated standard metrics. Please reach out to https://github.com/microsoft/ApplicationInsights-Java/issues if you have a use case for this.");
        instrumentationKeyAttributeNoLongerSupported = new WarningLogger(SpanDataMapper.class, AiSemanticAttributes.DEPRECATED_INSTRUMENTATION_KEY.getKey() + " is no longer supported because it is incompatible with pre-aggregated standard metrics. Please use \"connectionStringOverrides\" configuration, or reach out to https://github.com/microsoft/ApplicationInsights-Java/issues if you have a different use case.");
    }
}

