/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.localstorage;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.FileUtil;
import java.io.File;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

class LocalFileCache {
    private static final ClientLogger logger = new ClientLogger(LocalFileCache.class);
    private final Queue<File> persistedFilesCache = new ConcurrentLinkedDeque<File>();

    LocalFileCache(File folder) {
        this.persistedFilesCache.addAll(LocalFileCache.loadPersistedFiles(folder));
    }

    void addPersistedFile(File file) {
        this.persistedFilesCache.add(file);
    }

    File poll() {
        return this.persistedFilesCache.poll();
    }

    Queue<File> getPersistedFilesCache() {
        return this.persistedFilesCache;
    }

    private static List<File> loadPersistedFiles(File folder) {
        return FileUtil.listTrnFiles(folder).stream().filter(file -> !LocalFileCache.isExpired(file, TimeUnit.DAYS.toSeconds(2L))).sorted(Comparator.comparing(File::lastModified)).collect(Collectors.toList());
    }

    static boolean isExpired(File file, long expiredIntervalSeconds) {
        long timestamp;
        String name = file.getName();
        int index = name.indexOf(45);
        if (index == -1) {
            logger.verbose("unexpected .trn file name: {}", new Object[]{name});
            return true;
        }
        try {
            timestamp = Long.parseLong(name.substring(0, index));
        }
        catch (NumberFormatException e) {
            logger.verbose("unexpected .trn file name: {}", new Object[]{name});
            return true;
        }
        Date expirationDate = new Date(System.currentTimeMillis() - 1000L * expiredIntervalSeconds);
        Date fileDate = new Date(timestamp);
        return fileDate.before(expirationDate);
    }
}

