/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.localstorage;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalFileCache;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalFileLoader;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalFilePurger;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalFileSender;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalFileWriter;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalStorageStats;
import com.azure.monitor.opentelemetry.exporter.implementation.logging.DiagnosticTelemetryPipelineListener;
import com.azure.monitor.opentelemetry.exporter.implementation.models.ResponseError;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.AppInsightsByteBufferPool;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.ByteBufferOutputStream;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipeline;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineListener;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineRequest;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineResponse;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.StatusCode;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class LocalStorageTelemetryPipelineListener
implements TelemetryPipelineListener {
    private static final ClientLogger logger = new ClientLogger(LocalStorageTelemetryPipelineListener.class);
    private final LocalFileWriter localFileWriter;
    private final LocalFileSender localFileSender;
    private final LocalFilePurger localFilePurger;
    private final AtomicBoolean shutdown = new AtomicBoolean();

    public LocalStorageTelemetryPipelineListener(int diskPersistenceMaxSizeMb, File telemetryFolder, TelemetryPipeline pipeline, LocalStorageStats stats, boolean suppressWarnings) {
        LocalFileCache localFileCache = new LocalFileCache(telemetryFolder);
        LocalFileLoader loader = new LocalFileLoader(localFileCache, telemetryFolder, stats, suppressWarnings);
        this.localFileWriter = new LocalFileWriter(diskPersistenceMaxSizeMb, localFileCache, telemetryFolder, stats, suppressWarnings);
        long intervalSeconds = diskPersistenceMaxSizeMb > 50 ? 10L : 30L;
        this.localFileSender = new LocalFileSender(intervalSeconds, loader, pipeline, suppressWarnings);
        this.localFilePurger = new LocalFilePurger(telemetryFolder, suppressWarnings);
    }

    @Override
    public void onResponse(TelemetryPipelineRequest request, TelemetryPipelineResponse response) {
        int statusCode = response.getStatusCode();
        if (StatusCode.isRetryable(statusCode)) {
            this.localFileWriter.writeToDisk(request.getConnectionString(), request.getByteBuffers(), LocalStorageTelemetryPipelineListener.getOriginalErrorMessage(response));
        } else if (statusCode == 206) {
            this.processStatusCode206(request, response);
        }
    }

    private void processStatusCode206(TelemetryPipelineRequest request, TelemetryPipelineResponse response) {
        Set<ResponseError> errors = response.getErrors();
        errors.forEach(error -> logger.verbose("Error in telemetry: {}", new Object[]{error}));
        if (!errors.isEmpty()) {
            List<ByteBuffer> originalByteBuffers = request.getByteBuffers();
            byte[] gzippedBytes = LocalStorageTelemetryPipelineListener.convertByteBufferListToByteArray(originalByteBuffers);
            byte[] ungzippedBytes = LocalStorageTelemetryPipelineListener.ungzip(gzippedBytes);
            List<byte[]> serializedTelemetryItemsByteArrayList = LocalStorageTelemetryPipelineListener.splitBytesByNewline(ungzippedBytes);
            ArrayList<byte[]> toBePersisted = new ArrayList<byte[]>();
            for (ResponseError error2 : errors) {
                if (!StatusCode.isRetryable(error2.getStatusCode())) continue;
                toBePersisted.add(serializedTelemetryItemsByteArrayList.get(error2.getIndex()));
            }
            if (!toBePersisted.isEmpty()) {
                this.localFileWriter.writeToDisk(request.getConnectionString(), LocalStorageTelemetryPipelineListener.gzip(toBePersisted), "Received partial response code 206");
            }
        }
    }

    private static byte[] convertByteBufferListToByteArray(List<ByteBuffer> byteBuffers) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (ByteBuffer buffer : byteBuffers) {
            byte[] arr = new byte[buffer.remaining()];
            buffer.get(arr);
            try {
                baos.write(arr);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return baos.toByteArray();
    }

    private static List<ByteBuffer> gzip(List<byte[]> byteArrayList) {
        List<ByteBuffer> list;
        ByteBufferOutputStream result = new ByteBufferOutputStream(new AppInsightsByteBufferPool());
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(result);
            for (int i = 0; i < byteArrayList.size(); ++i) {
                gzipOutputStream.write(byteArrayList.get(i));
                if (i >= byteArrayList.size() - 1) continue;
                gzipOutputStream.write(10);
            }
            gzipOutputStream.close();
            List<ByteBuffer> resultByteBuffers = result.getByteBuffers();
            for (ByteBuffer byteBuffer : resultByteBuffers) {
                byteBuffer.flip();
            }
            list = result.getByteBuffers();
        }
        catch (Throwable throwable) {
            try {
                try {
                    result.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to encode list of ByteBuffers before persisting to the offline disk", e);
            }
        }
        result.close();
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] ungzip(byte[] rawBytes) {
        try (GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(rawBytes));){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int read;
                byte[] data = new byte[1024];
                while ((read = in.read(data)) != -1) {
                    baos.write(data, 0, read);
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to decode byte[]", e);
        }
    }

    static List<byte[]> splitBytesByNewline(byte[] inputBytes) {
        ArrayList<byte[]> lines = new ArrayList<byte[]>();
        int start = 0;
        for (int i = 0; i < inputBytes.length; ++i) {
            if (inputBytes[i] != 10) continue;
            lines.add(Arrays.copyOfRange(inputBytes, start, i));
            start = i + 1;
        }
        if (start < inputBytes.length) {
            lines.add(Arrays.copyOfRange(inputBytes, start, inputBytes.length));
        }
        return lines;
    }

    @Override
    public void onException(TelemetryPipelineRequest request, String errorMessage, Throwable throwable) {
        this.localFileWriter.writeToDisk(request.getConnectionString(), request.getByteBuffers(), errorMessage);
    }

    @Override
    public CompletableResultCode shutdown() {
        if (!this.shutdown.getAndSet(true)) {
            this.localFileSender.shutdown();
            this.localFilePurger.shutdown();
        }
        return CompletableResultCode.ofSuccess();
    }

    private static String getOriginalErrorMessage(TelemetryPipelineResponse response) {
        int statusCode = response.getStatusCode();
        if (statusCode == 401 || statusCode == 403) {
            return DiagnosticTelemetryPipelineListener.getErrorMessageFromCredentialRelatedResponse(statusCode, response.getBody());
        }
        return "Received response code " + statusCode;
    }
}

