/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.exporter.implementation.models.MonitorDomain;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RemoteDependencyData
extends MonitorDomain {
    private String id;
    private String name;
    private String resultCode;
    private String data;
    private String type;
    private String target;
    private String duration;
    private Boolean success;
    private Map<String, String> properties;
    private Map<String, Double> measurements;

    public String getId() {
        return this.id;
    }

    public RemoteDependencyData setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public RemoteDependencyData setName(String name) {
        this.name = name;
        return this;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public RemoteDependencyData setResultCode(String resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    public String getData() {
        return this.data;
    }

    public RemoteDependencyData setData(String data) {
        this.data = data;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public RemoteDependencyData setType(String type) {
        this.type = type;
        return this;
    }

    public String getTarget() {
        return this.target;
    }

    public RemoteDependencyData setTarget(String target) {
        this.target = target;
        return this;
    }

    public String getDuration() {
        return this.duration;
    }

    public RemoteDependencyData setDuration(String duration) {
        this.duration = duration;
        return this;
    }

    public Boolean isSuccess() {
        return this.success;
    }

    public RemoteDependencyData setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public RemoteDependencyData setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, Double> getMeasurements() {
        return this.measurements;
    }

    public RemoteDependencyData setMeasurements(Map<String, Double> measurements) {
        this.measurements = measurements;
        return this;
    }

    @Override
    public RemoteDependencyData setVersion(int version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("ver", this.getVersion());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("duration", this.duration);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("resultCode", this.resultCode);
        jsonWriter.writeStringField("data", this.data);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeBooleanField("success", this.success);
        jsonWriter.writeMapField("properties", this.properties, JsonWriter::writeString);
        jsonWriter.writeMapField("measurements", this.measurements, JsonWriter::writeDouble);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static RemoteDependencyData fromJson(JsonReader jsonReader) throws IOException {
        return (RemoteDependencyData)jsonReader.readObject(reader -> {
            RemoteDependencyData deserializedRemoteDependencyData = new RemoteDependencyData();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ver".equals(fieldName)) {
                    deserializedRemoteDependencyData.setVersion(reader.getInt());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRemoteDependencyData.name = reader.getString();
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedRemoteDependencyData.duration = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedRemoteDependencyData.id = reader.getString();
                    continue;
                }
                if ("resultCode".equals(fieldName)) {
                    deserializedRemoteDependencyData.resultCode = reader.getString();
                    continue;
                }
                if ("data".equals(fieldName)) {
                    deserializedRemoteDependencyData.data = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRemoteDependencyData.type = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedRemoteDependencyData.target = reader.getString();
                    continue;
                }
                if ("success".equals(fieldName)) {
                    deserializedRemoteDependencyData.success = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRemoteDependencyData.properties = reader.readMap(JsonReader::getString);
                    continue;
                }
                if ("measurements".equals(fieldName)) {
                    deserializedRemoteDependencyData.measurements = reader.readMap(JsonReader::getDouble);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedRemoteDependencyData.setAdditionalProperties(additionalProperties);
            return deserializedRemoteDependencyData;
        });
    }
}

