/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.exporter.implementation.models.MonitorDomain;
import com.azure.monitor.opentelemetry.exporter.implementation.models.SeverityLevel;
import com.azure.monitor.opentelemetry.exporter.implementation.models.TelemetryExceptionDetails;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class TelemetryExceptionData
extends MonitorDomain {
    private List<TelemetryExceptionDetails> exceptions;
    private SeverityLevel severityLevel;
    private String problemId;
    private Map<String, String> properties;
    private Map<String, Double> measurements;

    public List<TelemetryExceptionDetails> getExceptions() {
        return this.exceptions;
    }

    public TelemetryExceptionData setExceptions(List<TelemetryExceptionDetails> exceptions) {
        this.exceptions = exceptions;
        return this;
    }

    public SeverityLevel getSeverityLevel() {
        return this.severityLevel;
    }

    public TelemetryExceptionData setSeverityLevel(SeverityLevel severityLevel) {
        this.severityLevel = severityLevel;
        return this;
    }

    public String getProblemId() {
        return this.problemId;
    }

    public TelemetryExceptionData setProblemId(String problemId) {
        this.problemId = problemId;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public TelemetryExceptionData setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, Double> getMeasurements() {
        return this.measurements;
    }

    public TelemetryExceptionData setMeasurements(Map<String, Double> measurements) {
        this.measurements = measurements;
        return this;
    }

    @Override
    public TelemetryExceptionData setVersion(int version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("ver", this.getVersion());
        jsonWriter.writeArrayField("exceptions", this.exceptions, JsonWriter::writeJson);
        jsonWriter.writeStringField("severityLevel", this.severityLevel == null ? null : this.severityLevel.toString());
        jsonWriter.writeStringField("problemId", this.problemId);
        jsonWriter.writeMapField("properties", this.properties, JsonWriter::writeString);
        jsonWriter.writeMapField("measurements", this.measurements, JsonWriter::writeDouble);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TelemetryExceptionData fromJson(JsonReader jsonReader) throws IOException {
        return (TelemetryExceptionData)jsonReader.readObject(reader -> {
            TelemetryExceptionData deserializedTelemetryExceptionData = new TelemetryExceptionData();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ver".equals(fieldName)) {
                    deserializedTelemetryExceptionData.setVersion(reader.getInt());
                    continue;
                }
                if ("exceptions".equals(fieldName)) {
                    deserializedTelemetryExceptionData.exceptions = reader.readArray(TelemetryExceptionDetails::fromJson);
                    continue;
                }
                if ("severityLevel".equals(fieldName)) {
                    deserializedTelemetryExceptionData.severityLevel = SeverityLevel.fromString(reader.getString());
                    continue;
                }
                if ("problemId".equals(fieldName)) {
                    deserializedTelemetryExceptionData.problemId = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTelemetryExceptionData.properties = reader.readMap(JsonReader::getString);
                    continue;
                }
                if ("measurements".equals(fieldName)) {
                    deserializedTelemetryExceptionData.measurements = reader.readMap(JsonReader::getDouble);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedTelemetryExceptionData.setAdditionalProperties(additionalProperties);
            return deserializedTelemetryExceptionData;
        });
    }
}

