/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.quickpulse;

import com.azure.core.http.HttpRequest;
import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseDataCollector;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseNetworkHelper;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.model.QuickPulseEnvelope;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.model.QuickPulseMetrics;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.AzureMonitorMsgId;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.Strings;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Supplier;
import org.slf4j.MDC;

class QuickPulseDataFetcher {
    private static final ClientLogger logger = new ClientLogger(QuickPulseDataFetcher.class);
    private final QuickPulseDataCollector collector;
    private final ArrayBlockingQueue<HttpRequest> sendQueue;
    private final QuickPulseNetworkHelper networkHelper = new QuickPulseNetworkHelper();
    private final Supplier<URL> endpointUrl;
    private final Supplier<String> instrumentationKey;
    private final String roleName;
    private final String instanceName;
    private final String machineName;
    private final String quickPulseId;
    private final String sdkVersion;

    public QuickPulseDataFetcher(QuickPulseDataCollector collector, ArrayBlockingQueue<HttpRequest> sendQueue, Supplier<URL> endpointUrl, Supplier<String> instrumentationKey, String roleName, String instanceName, String machineName, String quickPulseId) {
        this.collector = collector;
        this.sendQueue = sendQueue;
        this.endpointUrl = endpointUrl;
        this.instrumentationKey = instrumentationKey;
        this.roleName = roleName;
        this.instanceName = instanceName;
        this.machineName = machineName;
        this.quickPulseId = quickPulseId;
        this.sdkVersion = this.getCurrentSdkVersion();
    }

    String getCurrentSdkVersion() {
        return "unknown";
    }

    public void prepareQuickPulseDataForSend(String redirectedEndpoint) {
        block13: {
            try {
                QuickPulseDataCollector.FinalCounters counters = this.collector.getAndRestart();
                if (counters == null) {
                    return;
                }
                Date currentDate = new Date();
                String endpointPrefix = Strings.isNullOrEmpty(redirectedEndpoint) ? this.getQuickPulseEndpoint() : redirectedEndpoint;
                HttpRequest request = this.networkHelper.buildRequest(currentDate, this.getEndpointUrl(endpointPrefix));
                request.setBody(this.buildPostEntity(counters));
                if (!this.sendQueue.offer(request)) {
                    logger.verbose("Quick Pulse send queue is full");
                }
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                try (MDC.MDCCloseable ignored = AzureMonitorMsgId.QUICK_PULSE_SEND_ERROR.makeActive();){
                    logger.error("Quick Pulse failed to prepare data for send", new Object[]{e});
                }
                catch (Throwable t2) {
                    if (!(t2 instanceof Error)) break block13;
                    throw (Error)t2;
                }
            }
        }
    }

    String getEndpointUrl(String endpointPrefix) {
        return endpointPrefix + "/post?ikey=" + this.instrumentationKey.get();
    }

    String getQuickPulseEndpoint() {
        return this.endpointUrl.get().toString() + "QuickPulseService.svc";
    }

    private String buildPostEntity(QuickPulseDataCollector.FinalCounters counters) throws IOException {
        ArrayList<QuickPulseEnvelope> envelopes = new ArrayList<QuickPulseEnvelope>();
        QuickPulseEnvelope postEnvelope = new QuickPulseEnvelope();
        postEnvelope.setDocuments(counters.documentList);
        postEnvelope.setInstance(this.instanceName);
        postEnvelope.setInvariantVersion(1);
        postEnvelope.setMachineName(this.machineName);
        postEnvelope.setRoleName(this.roleName);
        postEnvelope.setInstrumentationKey(this.instrumentationKey.get());
        postEnvelope.setStreamId(this.quickPulseId);
        postEnvelope.setVersion(this.sdkVersion);
        postEnvelope.setTimeStamp("/Date(" + System.currentTimeMillis() + ")/");
        postEnvelope.setMetrics(QuickPulseDataFetcher.addMetricsToQuickPulseEnvelope(counters));
        envelopes.add(postEnvelope);
        return postEnvelope.toJsonString().replace("/", "\\/");
    }

    private static List<QuickPulseMetrics> addMetricsToQuickPulseEnvelope(QuickPulseDataCollector.FinalCounters counters) {
        ArrayList<QuickPulseMetrics> metricsList = new ArrayList<QuickPulseMetrics>();
        metricsList.add(new QuickPulseMetrics("\\ApplicationInsights\\Requests/Sec", counters.requests, 1));
        if (counters.requests != 0) {
            metricsList.add(new QuickPulseMetrics("\\ApplicationInsights\\Request Duration", counters.requestsDuration / (double)counters.requests, counters.requests));
        }
        metricsList.add(new QuickPulseMetrics("\\ApplicationInsights\\Requests Failed/Sec", counters.unsuccessfulRequests, 1));
        metricsList.add(new QuickPulseMetrics("\\ApplicationInsights\\Requests Succeeded/Sec", counters.requests - counters.unsuccessfulRequests, 1));
        metricsList.add(new QuickPulseMetrics("\\ApplicationInsights\\Dependency Calls/Sec", counters.rdds, 1));
        if (counters.rdds != 0L) {
            metricsList.add(new QuickPulseMetrics("\\ApplicationInsights\\Dependency Call Duration", counters.rddsDuration / (double)counters.rdds, (int)counters.rdds));
        }
        metricsList.add(new QuickPulseMetrics("\\ApplicationInsights\\Dependency Calls Failed/Sec", counters.unsuccessfulRdds, 1));
        metricsList.add(new QuickPulseMetrics("\\ApplicationInsights\\Dependency Calls Succeeded/Sec", counters.rdds - (long)counters.unsuccessfulRdds, 1));
        metricsList.add(new QuickPulseMetrics("\\ApplicationInsights\\Exceptions/Sec", counters.exceptions, 1));
        metricsList.add(new QuickPulseMetrics("\\Memory\\Committed Bytes", counters.memoryCommitted, 1));
        metricsList.add(new QuickPulseMetrics("\\Processor(_Total)\\% Processor Time", counters.cpuUsage, 1));
        return metricsList;
    }
}

