/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.statsbeat;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.Context;
import com.azure.core.util.tracing.Tracer;
import com.azure.monitor.opentelemetry.exporter.implementation.NoopTracer;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.AttachStatsbeat;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.CustomDimensions;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.MetadataInstanceResponse;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.OperatingSystem;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.ThreadPoolUtils;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AzureMetadataService
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AzureMetadataService.class);
    private static final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(ThreadPoolUtils.createDaemonThreadFactory(AzureMetadataService.class));
    private static final String API_VERSION = "api-version=2017-08-01";
    private static final String JSON_FORMAT = "format=json";
    private static final String BASE_URL = "http://169.254.169.254/metadata/instance/compute";
    private static final String ENDPOINT = "http://169.254.169.254/metadata/instance/compute?api-version=2017-08-01&format=json";
    private final AttachStatsbeat attachStatsbeat;
    private final CustomDimensions customDimensions;
    private final HttpPipeline httpPipeline;
    private final Consumer<MetadataInstanceResponse> vmMetadataServiceCallback;

    AzureMetadataService(AttachStatsbeat attachStatsbeat, CustomDimensions customDimensions, Consumer<MetadataInstanceResponse> vmMetadataServiceCallback) {
        this.attachStatsbeat = attachStatsbeat;
        this.customDimensions = customDimensions;
        this.httpPipeline = new HttpPipelineBuilder().tracer((Tracer)new NoopTracer()).build();
        this.vmMetadataServiceCallback = vmMetadataServiceCallback;
    }

    void scheduleWithFixedDelay(long interval) {
        scheduledExecutor.scheduleWithFixedDelay(this, 60L, interval, TimeUnit.SECONDS);
    }

    void shutdown() {
        logger.debug("Shutting down Azure Metadata Service.");
        scheduledExecutor.shutdown();
    }

    void updateMetadata(String response) throws IOException {
        this.updateMetadata(MetadataInstanceResponse.fromJson(response));
    }

    private void updateMetadata(MetadataInstanceResponse metadataInstanceResponse) {
        String osType;
        this.vmMetadataServiceCallback.accept(metadataInstanceResponse);
        this.attachStatsbeat.updateMetadataInstance(metadataInstanceResponse);
        this.customDimensions.setResourceProviderVm();
        switch (osType = metadataInstanceResponse.getOsType()) {
            case "Windows": {
                this.customDimensions.setOperatingSystem(OperatingSystem.OS_WINDOWS);
                break;
            }
            case "Linux": {
                this.customDimensions.setOperatingSystem(OperatingSystem.OS_LINUX);
                break;
            }
        }
    }

    @Override
    public void run() {
        MetadataInstanceResponse metadataInstanceResponse;
        HttpResponse response;
        HttpRequest request = new HttpRequest(HttpMethod.GET, ENDPOINT);
        request.setHeader(HttpHeaderName.fromString((String)"Metadata"), "true");
        try {
            response = this.httpPipeline.sendSync(request, Context.NONE);
        }
        catch (RuntimeException e) {
            logger.debug("Shutting down AzureMetadataService scheduler: is not running on Azure VM or VMSS");
            logger.trace(e.getMessage(), (Throwable)e);
            scheduledExecutor.shutdown();
            return;
        }
        if (response == null) {
            throw new AssertionError((Object)"http response mono returned empty");
        }
        String json = (String)response.getBodyAsString().block();
        if (json == null) {
            throw new AssertionError((Object)"response body mono returned empty");
        }
        try {
            metadataInstanceResponse = MetadataInstanceResponse.fromJson(json);
        }
        catch (IOException e) {
            logger.debug("Shutting down AzureMetadataService scheduler: error parsing response from Azure Metadata Service: {}", (Object)json, (Object)e);
            scheduledExecutor.shutdown();
            return;
        }
        this.updateMetadata(metadataInstanceResponse);
    }
}

