/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.statsbeat;

import com.azure.monitor.opentelemetry.exporter.implementation.builders.StatsbeatTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.OperatingSystem;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.ResourceProvider;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.RpAttachType;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.PropertyHelper;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.SystemInformation;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.VersionGenerator;

public class CustomDimensions {
    private volatile ResourceProvider resourceProvider = ResourceProvider.initResourceProvider();
    private volatile OperatingSystem operatingSystem = CustomDimensions.initOperatingSystem();
    private final String attachType;
    private final String runtimeVersion;
    private final String language;
    private final String sdkVersion = CustomDimensions.initSdkVersion();

    CustomDimensions() {
        this.runtimeVersion = System.getProperty("java.version");
        this.attachType = RpAttachType.getRpAttachTypeString();
        this.language = "java";
    }

    ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    void setResourceProviderVm() {
        this.resourceProvider = ResourceProvider.RP_VM;
    }

    void setOperatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    void populateProperties(StatsbeatTelemetryBuilder telemetryBuilder, String customerIkey) {
        telemetryBuilder.addProperty("rp", this.resourceProvider.getValue());
        telemetryBuilder.addProperty("os", this.operatingSystem.getValue());
        telemetryBuilder.addProperty("attach", this.attachType);
        telemetryBuilder.addProperty("cikey", customerIkey);
        telemetryBuilder.addProperty("runtimeVersion", this.runtimeVersion);
        telemetryBuilder.addProperty("language", this.language);
        telemetryBuilder.addProperty("version", this.sdkVersion);
    }

    private static OperatingSystem initOperatingSystem() {
        if (SystemInformation.isWindows()) {
            return OperatingSystem.OS_WINDOWS;
        }
        if (SystemInformation.isLinux()) {
            return OperatingSystem.OS_LINUX;
        }
        return OperatingSystem.OS_UNKNOWN;
    }

    private static String initSdkVersion() {
        if (RpAttachType.getRpAttachType() == RpAttachType.MANUAL) {
            return VersionGenerator.getSdkVersion();
        }
        String qualifiedSdkVersionString = PropertyHelper.getQualifiedSdkVersionString();
        return qualifiedSdkVersionString.substring(qualifiedSdkVersionString.lastIndexOf(58) + 1);
    }
}

