/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.util.ClientOptions;
import com.azure.monitor.opentelemetry.exporter.implementation.configuration.ConnectionString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class AzureMonitorExporterOptions {
    ConnectionString connectionString;
    TokenCredential credential;
    HttpPipeline httpPipeline;
    HttpClient httpClient;
    HttpLogOptions httpLogOptions;
    final List<HttpPipelinePolicy> httpPipelinePolicies = new ArrayList<HttpPipelinePolicy>();
    ClientOptions clientOptions;
    RetryOptions retryOptions;

    public AzureMonitorExporterOptions pipeline(HttpPipeline pipeline) {
        this.httpPipeline = pipeline;
        return this;
    }

    public AzureMonitorExporterOptions httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public AzureMonitorExporterOptions httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public AzureMonitorExporterOptions addPolicy(HttpPipelinePolicy pipelinePolicy) {
        this.httpPipelinePolicies.add(Objects.requireNonNull(pipelinePolicy, "'policy' cannot be null."));
        return this;
    }

    public AzureMonitorExporterOptions retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public AzureMonitorExporterOptions clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public AzureMonitorExporterOptions connectionString(String connectionString) {
        this.connectionString = ConnectionString.parse(connectionString);
        return this;
    }

    public AzureMonitorExporterOptions credential(TokenCredential credential) {
        this.credential = credential;
        return this;
    }
}

