/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.exporter.implementation.models.MonitorDomain;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AvailabilityData
extends MonitorDomain {
    private String id;
    private String name;
    private String duration;
    private boolean success;
    private String runLocation;
    private String message;
    private Map<String, String> properties;
    private Map<String, Double> measurements;

    public String getId() {
        return this.id;
    }

    public AvailabilityData setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public AvailabilityData setName(String name) {
        this.name = name;
        return this;
    }

    public String getDuration() {
        return this.duration;
    }

    public AvailabilityData setDuration(String duration) {
        this.duration = duration;
        return this;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public AvailabilityData setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public String getRunLocation() {
        return this.runLocation;
    }

    public AvailabilityData setRunLocation(String runLocation) {
        this.runLocation = runLocation;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public AvailabilityData setMessage(String message) {
        this.message = message;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public AvailabilityData setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, Double> getMeasurements() {
        return this.measurements;
    }

    public AvailabilityData setMeasurements(Map<String, Double> measurements) {
        this.measurements = measurements;
        return this;
    }

    @Override
    public AvailabilityData setVersion(int version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("ver", this.getVersion());
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("duration", this.duration);
        jsonWriter.writeBooleanField("success", this.success);
        jsonWriter.writeStringField("runLocation", this.runLocation);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeMapField("properties", this.properties, JsonWriter::writeString);
        jsonWriter.writeMapField("measurements", this.measurements, JsonWriter::writeDouble);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AvailabilityData fromJson(JsonReader jsonReader) throws IOException {
        return (AvailabilityData)jsonReader.readObject(reader -> {
            AvailabilityData deserializedAvailabilityData = new AvailabilityData();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ver".equals(fieldName)) {
                    deserializedAvailabilityData.setVersion(reader.getInt());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedAvailabilityData.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAvailabilityData.name = reader.getString();
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedAvailabilityData.duration = reader.getString();
                    continue;
                }
                if ("success".equals(fieldName)) {
                    deserializedAvailabilityData.success = reader.getBoolean();
                    continue;
                }
                if ("runLocation".equals(fieldName)) {
                    deserializedAvailabilityData.runLocation = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedAvailabilityData.message = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAvailabilityData.properties = reader.readMap(JsonReader::getString);
                    continue;
                }
                if ("measurements".equals(fieldName)) {
                    deserializedAvailabilityData.measurements = reader.readMap(JsonReader::getDouble);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAvailabilityData.setAdditionalProperties(additionalProperties);
            return deserializedAvailabilityData;
        });
    }
}

