/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.exporter.implementation.models.MonitorDomain;
import com.azure.monitor.opentelemetry.exporter.implementation.models.SeverityLevel;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MessageData
extends MonitorDomain {
    private String message;
    private SeverityLevel severityLevel;
    private Map<String, String> properties;
    private Map<String, Double> measurements;

    public String getMessage() {
        return this.message;
    }

    public MessageData setMessage(String message) {
        this.message = message;
        return this;
    }

    public SeverityLevel getSeverityLevel() {
        return this.severityLevel;
    }

    public MessageData setSeverityLevel(SeverityLevel severityLevel) {
        this.severityLevel = severityLevel;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public MessageData setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, Double> getMeasurements() {
        return this.measurements;
    }

    public MessageData setMeasurements(Map<String, Double> measurements) {
        this.measurements = measurements;
        return this;
    }

    @Override
    public MessageData setVersion(int version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("ver", this.getVersion());
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("severityLevel", this.severityLevel == null ? null : this.severityLevel.toString());
        jsonWriter.writeMapField("properties", this.properties, JsonWriter::writeString);
        jsonWriter.writeMapField("measurements", this.measurements, JsonWriter::writeDouble);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MessageData fromJson(JsonReader jsonReader) throws IOException {
        return (MessageData)jsonReader.readObject(reader -> {
            MessageData deserializedMessageData = new MessageData();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ver".equals(fieldName)) {
                    deserializedMessageData.setVersion(reader.getInt());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedMessageData.message = reader.getString();
                    continue;
                }
                if ("severityLevel".equals(fieldName)) {
                    deserializedMessageData.severityLevel = SeverityLevel.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMessageData.properties = reader.readMap(JsonReader::getString);
                    continue;
                }
                if ("measurements".equals(fieldName)) {
                    deserializedMessageData.measurements = reader.readMap(JsonReader::getDouble);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMessageData.setAdditionalProperties(additionalProperties);
            return deserializedMessageData;
        });
    }
}

