/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.exporter.implementation.models.MonitorDomain;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class PageViewData
extends MonitorDomain {
    private String id;
    private String name;
    private String url;
    private String duration;
    private String referredUri;
    private Map<String, String> properties;
    private Map<String, Double> measurements;

    public String getId() {
        return this.id;
    }

    public PageViewData setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public PageViewData setName(String name) {
        this.name = name;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public PageViewData setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getDuration() {
        return this.duration;
    }

    public PageViewData setDuration(String duration) {
        this.duration = duration;
        return this;
    }

    public String getReferredUri() {
        return this.referredUri;
    }

    public PageViewData setReferredUri(String referredUri) {
        this.referredUri = referredUri;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public PageViewData setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, Double> getMeasurements() {
        return this.measurements;
    }

    public PageViewData setMeasurements(Map<String, Double> measurements) {
        this.measurements = measurements;
        return this;
    }

    @Override
    public PageViewData setVersion(int version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("ver", this.getVersion());
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("duration", this.duration);
        jsonWriter.writeStringField("referredUri", this.referredUri);
        jsonWriter.writeMapField("properties", this.properties, JsonWriter::writeString);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PageViewData fromJson(JsonReader jsonReader) throws IOException {
        return (PageViewData)jsonReader.readObject(reader -> {
            PageViewData deserializedPageViewData = new PageViewData();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ver".equals(fieldName)) {
                    deserializedPageViewData.setVersion(reader.getInt());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedPageViewData.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPageViewData.name = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedPageViewData.url = reader.getString();
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedPageViewData.duration = reader.getString();
                    continue;
                }
                if ("referredUri".equals(fieldName)) {
                    deserializedPageViewData.referredUri = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPageViewData.properties = reader.readMap(JsonReader::getString);
                    continue;
                }
                if ("measurements".equals(fieldName)) {
                    deserializedPageViewData.measurements = reader.readMap(JsonReader::getDouble);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedPageViewData.setAdditionalProperties(additionalProperties);
            return deserializedPageViewData;
        });
    }
}

