/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.opentelemetry.exporter.implementation.models.ResponseError;
import java.io.IOException;
import java.util.List;

public final class Response
implements JsonSerializable<Response> {
    private int itemsReceived;
    private int itemsAccepted;
    private String appId;
    private List<ResponseError> errors;

    public int getItemsReceived() {
        return this.itemsReceived;
    }

    public Response setItemsReceived(int itemReceived) {
        this.itemsReceived = itemReceived;
        return this;
    }

    public int getItemsAccepted() {
        return this.itemsAccepted;
    }

    public Response setItemsAccepted(int itemsAccepted) {
        this.itemsAccepted = itemsAccepted;
        return this;
    }

    public String getAppId() {
        return this.appId;
    }

    public Response setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public List<ResponseError> getErrors() {
        return this.errors;
    }

    public Response setErrors(List<ResponseError> errors) {
        this.errors = errors;
        return this;
    }

    public String toString() {
        return "Response{itemsReceived=" + this.itemsReceived + ", itemsAccepted=" + this.itemsAccepted + ", appId='" + this.appId + '\'' + ", errors=" + this.errors + '}';
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeIntField("itemsReceived", this.itemsReceived).writeIntField("itemsAccepted", this.itemsAccepted).writeStringField("appId", this.appId).writeArrayField("errors", this.errors, JsonWriter::writeJson).writeEndObject();
    }

    public static Response fromJson(JsonReader jsonReader) throws IOException {
        return (Response)jsonReader.readObject(reader -> {
            Response deserializedValue = new Response();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("itemsReceived".equals(fieldName)) {
                    deserializedValue.setItemsReceived(reader.getInt());
                    continue;
                }
                if ("itemsAccepted".equals(fieldName)) {
                    deserializedValue.setItemsAccepted(reader.getInt());
                    continue;
                }
                if ("appId".equals(fieldName)) {
                    deserializedValue.setAppId(reader.getString());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errorList = reader.readArray(ResponseError::fromJson);
                    deserializedValue.setErrors(errorList);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValue;
        });
    }
}

