/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class StackFrame
implements JsonSerializable<StackFrame> {
    private int level;
    private String method;
    private String assembly;
    private String fileName;
    private Integer line;

    public int getLevel() {
        return this.level;
    }

    public StackFrame setLevel(int level) {
        this.level = level;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public StackFrame setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getAssembly() {
        return this.assembly;
    }

    public StackFrame setAssembly(String assembly) {
        this.assembly = assembly;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public StackFrame setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public Integer getLine() {
        return this.line;
    }

    public StackFrame setLine(Integer line) {
        this.line = line;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("level", this.level);
        jsonWriter.writeStringField("method", this.method);
        jsonWriter.writeStringField("assembly", this.assembly);
        jsonWriter.writeStringField("fileName", this.fileName);
        jsonWriter.writeNumberField("line", (Number)this.line);
        return jsonWriter.writeEndObject();
    }

    public static StackFrame fromJson(JsonReader jsonReader) throws IOException {
        return (StackFrame)jsonReader.readObject(reader -> {
            StackFrame deserializedStackFrame = new StackFrame();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("level".equals(fieldName)) {
                    deserializedStackFrame.level = reader.getInt();
                    continue;
                }
                if ("method".equals(fieldName)) {
                    deserializedStackFrame.method = reader.getString();
                    continue;
                }
                if ("assembly".equals(fieldName)) {
                    deserializedStackFrame.assembly = reader.getString();
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedStackFrame.fileName = reader.getString();
                    continue;
                }
                if ("line".equals(fieldName)) {
                    deserializedStackFrame.line = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStackFrame;
        });
    }
}

