/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.quickpulse;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.logging.OperationLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseHeaderInfo;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseNetworkHelper;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseStatus;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.model.QuickPulseEnvelope;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.Strings;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import reactor.util.annotation.Nullable;

class QuickPulsePingSender {
    private static final ClientLogger logger = new ClientLogger(QuickPulsePingSender.class);
    private static final OperationLogger operationLogger = new OperationLogger(QuickPulsePingSender.class, "Pinging live metrics endpoint");
    private static final AtomicBoolean friendlyExceptionThrown = new AtomicBoolean();
    private final HttpPipeline httpPipeline;
    private final QuickPulseNetworkHelper networkHelper = new QuickPulseNetworkHelper();
    private volatile QuickPulseEnvelope pingEnvelope;
    private final Supplier<URL> endpointUrl;
    private final Supplier<String> instrumentationKey;
    private final String roleName;
    private final String instanceName;
    private final String machineName;
    private final String quickPulseId;
    private long lastValidTransmission = 0L;
    private final String sdkVersion;

    QuickPulsePingSender(HttpPipeline httpPipeline, Supplier<URL> endpointUrl, Supplier<String> instrumentationKey, String roleName, String instanceName, String machineName, String quickPulseId, String sdkVersion) {
        this.httpPipeline = httpPipeline;
        this.endpointUrl = endpointUrl;
        this.instrumentationKey = instrumentationKey;
        this.roleName = roleName;
        this.instanceName = instanceName;
        this.machineName = machineName;
        this.quickPulseId = quickPulseId;
        this.sdkVersion = sdkVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QuickPulseHeaderInfo ping(String redirectedEndpoint) {
        String instrumentationKey = this.getInstrumentationKey();
        if (Strings.isNullOrEmpty(instrumentationKey)) {
            return new QuickPulseHeaderInfo(QuickPulseStatus.QP_IS_OFF);
        }
        Date currentDate = new Date();
        String endpointPrefix = Strings.isNullOrEmpty(redirectedEndpoint) ? this.getQuickPulseEndpoint() : redirectedEndpoint;
        HttpRequest request = this.networkHelper.buildPingRequest(currentDate, this.getQuickPulsePingUri(endpointPrefix), this.quickPulseId, this.machineName, this.roleName, this.instanceName);
        long sendTime = System.nanoTime();
        try (HttpResponse response = null;){
            request.setBody(this.buildPingEntity(currentDate.getTime()));
            response = this.httpPipeline.sendSync(request, Context.NONE);
            if (response == null) {
                throw new AssertionError((Object)"http response mono returned empty");
            }
            if (this.networkHelper.isSuccess(response)) {
                QuickPulseHeaderInfo quickPulseHeaderInfo = this.networkHelper.getQuickPulseHeaderInfo(response);
                switch (quickPulseHeaderInfo.getQuickPulseStatus()) {
                    case QP_IS_OFF: 
                    case QP_IS_ON: {
                        this.lastValidTransmission = sendTime;
                        operationLogger.recordSuccess();
                        QuickPulseHeaderInfo quickPulseHeaderInfo2 = quickPulseHeaderInfo;
                        return quickPulseHeaderInfo2;
                    }
                }
            }
        }
        return this.onPingError(sendTime);
    }

    String getQuickPulsePingUri(String endpointPrefix) {
        return endpointPrefix + "/ping?ikey=" + this.getInstrumentationKey();
    }

    @Nullable
    private String getInstrumentationKey() {
        return this.instrumentationKey.get();
    }

    String getQuickPulseEndpoint() {
        return this.endpointUrl.get().toString() + "QuickPulseService.svc";
    }

    private String buildPingEntity(long timeInMillis) throws IOException {
        if (this.pingEnvelope == null) {
            this.pingEnvelope = new QuickPulseEnvelope();
            this.pingEnvelope.setInstance(this.instanceName);
            this.pingEnvelope.setInvariantVersion(1);
            this.pingEnvelope.setMachineName(this.machineName);
            this.pingEnvelope.setRoleName(this.roleName);
            this.pingEnvelope.setStreamId(this.quickPulseId);
            this.pingEnvelope.setVersion(this.sdkVersion);
        }
        this.pingEnvelope.setTimeStamp("/Date(" + timeInMillis + ")/");
        return this.pingEnvelope.toJsonString().replace("/", "\\/");
    }

    private QuickPulseHeaderInfo onPingError(long sendTime) {
        double timeFromLastValidTransmission = (double)(sendTime - this.lastValidTransmission) / 1.0E9;
        if (timeFromLastValidTransmission >= 60.0) {
            return new QuickPulseHeaderInfo(QuickPulseStatus.ERROR);
        }
        return new QuickPulseHeaderInfo(QuickPulseStatus.QP_IS_OFF);
    }
}

