/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.model;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public class QuickPulseDocument
implements JsonSerializable<QuickPulseDocument> {
    private String type;
    private String documentType;
    private String version;
    private String operationId;
    private Map<String, String> properties;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return this.toJsonShared(jsonWriter.writeStartObject()).writeEndObject();
    }

    JsonWriter toJsonShared(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStringField("__type", this.type).writeStringField("DocumentType", this.documentType).writeStringField("Version", this.version).writeStringField("OperationId", this.operationId).writeMapField("Properties", this.properties, JsonWriter::writeString);
    }

    public static QuickPulseDocument fromJson(JsonReader jsonReader) throws IOException {
        return (QuickPulseDocument)jsonReader.readObject(reader -> {
            QuickPulseDocument document = new QuickPulseDocument();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if (QuickPulseDocument.fromJsonShared(document, fieldName, reader)) continue;
                reader.skipChildren();
            }
            return document;
        });
    }

    static boolean fromJsonShared(QuickPulseDocument document, String fieldName, JsonReader jsonReader) throws IOException {
        if ("__type".equals(fieldName)) {
            document.type = jsonReader.getString();
            return true;
        }
        if ("DocumentType".equals(fieldName)) {
            document.documentType = jsonReader.getFieldName();
            return true;
        }
        if ("Version".equals(fieldName)) {
            document.version = jsonReader.getString();
            return true;
        }
        if ("OperationId".equals(fieldName)) {
            document.operationId = jsonReader.getFieldName();
            return true;
        }
        if ("Properties".equals(fieldName)) {
            document.properties = jsonReader.readMap(JsonReader::getString);
            return true;
        }
        return false;
    }
}

