/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.model;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class QuickPulseMetrics
implements JsonSerializable<QuickPulseMetrics> {
    private final String name;
    private final double value;
    private final int weight;

    public QuickPulseMetrics(String name, double value, int weight) {
        this.name = name;
        this.value = value;
        this.weight = weight;
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public int getWeight() {
        return this.weight;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("Name", this.name).writeDoubleField("Value", this.value).writeIntField("Weight", this.weight).writeEndObject();
    }

    public static QuickPulseMetrics fromJson(JsonReader jsonReader) throws IOException {
        return (QuickPulseMetrics)jsonReader.readObject(reader -> {
            String name = null;
            double value = 0.0;
            int weight = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("Name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("Value".equals(fieldName)) {
                    value = reader.getDouble();
                    continue;
                }
                if ("Weight".equals(fieldName)) {
                    weight = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new QuickPulseMetrics(name, value, weight);
        });
    }
}

