/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.utils;

import com.azure.monitor.opentelemetry.exporter.implementation.utils.HostName;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.Strings;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ServiceAttributes;
import io.opentelemetry.semconv.incubating.CloudIncubatingAttributes;
import io.opentelemetry.semconv.incubating.K8sIncubatingAttributes;
import io.opentelemetry.semconv.incubating.ServiceIncubatingAttributes;

public final class AksResourceAttributes {
    private static final String AZURE_AKS = "azure_aks";
    private static final String UNKNOWN_SERVICE = "unknown_service";

    public static boolean isAks(Resource resource) {
        return AZURE_AKS.equals(resource.getAttribute(CloudIncubatingAttributes.CLOUD_PLATFORM));
    }

    public static String getAksRoleName(Resource resource) {
        String serviceName = (String)resource.getAttribute(ServiceAttributes.SERVICE_NAME);
        if (!Strings.isNullOrEmpty(serviceName) && !serviceName.startsWith(UNKNOWN_SERVICE)) {
            return serviceName;
        }
        String k8sDeploymentName = (String)resource.getAttribute(K8sIncubatingAttributes.K8S_DEPLOYMENT_NAME);
        if (!Strings.isNullOrEmpty(k8sDeploymentName)) {
            return k8sDeploymentName;
        }
        String k8sReplicaSetName = (String)resource.getAttribute(K8sIncubatingAttributes.K8S_REPLICASET_NAME);
        if (!Strings.isNullOrEmpty(k8sReplicaSetName)) {
            return k8sReplicaSetName;
        }
        String k8sStatefulSetName = (String)resource.getAttribute(K8sIncubatingAttributes.K8S_STATEFULSET_NAME);
        if (!Strings.isNullOrEmpty(k8sStatefulSetName)) {
            return k8sStatefulSetName;
        }
        String k8sJobName = (String)resource.getAttribute(K8sIncubatingAttributes.K8S_JOB_NAME);
        if (!Strings.isNullOrEmpty(k8sJobName)) {
            return k8sJobName;
        }
        String k8sCronJobName = (String)resource.getAttribute(K8sIncubatingAttributes.K8S_CRONJOB_NAME);
        if (!Strings.isNullOrEmpty(k8sCronJobName)) {
            return k8sCronJobName;
        }
        String k8sDaemonSetName = (String)resource.getAttribute(K8sIncubatingAttributes.K8S_DAEMONSET_NAME);
        if (!Strings.isNullOrEmpty(k8sDaemonSetName)) {
            return k8sDaemonSetName;
        }
        return serviceName;
    }

    public static String getAksRoleInstance(Resource resource) {
        String serviceInstanceId = (String)resource.getAttribute(ServiceIncubatingAttributes.SERVICE_INSTANCE_ID);
        if (!Strings.isNullOrEmpty(serviceInstanceId)) {
            return serviceInstanceId;
        }
        String k8sPodName = (String)resource.getAttribute(K8sIncubatingAttributes.K8S_POD_NAME);
        if (!Strings.isNullOrEmpty(k8sPodName)) {
            return k8sPodName;
        }
        return HostName.get();
    }
}

