/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.utils;

import com.azure.monitor.opentelemetry.exporter.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.models.ContextTagKeys;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.AksResourceAttributes;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.HostName;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ServiceAttributes;
import io.opentelemetry.semconv.incubating.ServiceIncubatingAttributes;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public final class ResourceParser {
    private static final String DEFAULT_SERVICE_NAME = "unknown_service:java";
    private final String websiteSiteName = ResourceParser.getWebsiteSiteNameEnvVar(envVars::get);
    private final String websiteSiteInstance;

    public ResourceParser() {
        this(System.getenv());
    }

    ResourceParser(Map<String, String> envVars) {
        this.websiteSiteInstance = envVars.get("WEBSITE_INSTANCE_ID");
    }

    public void updateRoleNameAndInstance(AbstractTelemetryBuilder builder, Resource resource) {
        if (AksResourceAttributes.isAks(resource)) {
            builder.addTag(ContextTagKeys.AI_CLOUD_ROLE.toString(), AksResourceAttributes.getAksRoleName(resource));
            builder.addTag(ContextTagKeys.AI_CLOUD_ROLE_INSTANCE.toString(), AksResourceAttributes.getAksRoleInstance(resource));
            return;
        }
        Map<String, String> tags = builder.build().getTags();
        if (tags == null || !tags.containsKey(ContextTagKeys.AI_CLOUD_ROLE.toString())) {
            builder.addTag(ContextTagKeys.AI_CLOUD_ROLE.toString(), this.getRoleName(resource));
        }
        if (tags == null || !tags.containsKey(ContextTagKeys.AI_CLOUD_ROLE_INSTANCE.toString())) {
            builder.addTag(ContextTagKeys.AI_CLOUD_ROLE_INSTANCE.toString(), this.getRoleInstance(resource));
        }
    }

    private String getRoleName(Resource resource) {
        String serviceName = (String)resource.getAttribute(ServiceAttributes.SERVICE_NAME);
        if ((serviceName == null || DEFAULT_SERVICE_NAME.equals(serviceName)) && this.websiteSiteName != null) {
            serviceName = this.websiteSiteName;
        }
        String serviceNamespace = (String)resource.getAttribute(ServiceIncubatingAttributes.SERVICE_NAMESPACE);
        if (serviceName != null && serviceNamespace != null) {
            return "[" + serviceNamespace + "]/" + serviceName;
        }
        if (serviceName != null) {
            return serviceName;
        }
        if (serviceNamespace != null) {
            return "[" + serviceNamespace + "]";
        }
        return DEFAULT_SERVICE_NAME;
    }

    private String getRoleInstance(Resource resource) {
        String roleInstance = (String)resource.getAttribute(ServiceIncubatingAttributes.SERVICE_INSTANCE_ID);
        if (roleInstance != null) {
            return roleInstance;
        }
        roleInstance = this.websiteSiteInstance;
        if (roleInstance != null) {
            return roleInstance;
        }
        return HostName.get();
    }

    public static String getWebsiteSiteNameEnvVar(Function<String, String> envVars) {
        String websiteSiteName = envVars.apply("WEBSITE_SITE_NAME");
        if (websiteSiteName != null && ResourceParser.inAzureFunctionsWorker(envVars)) {
            return websiteSiteName.toLowerCase(Locale.ROOT);
        }
        return websiteSiteName;
    }

    public static boolean inAzureFunctionsWorker(Function<String, String> envVars) {
        return "java".equals(envVars.apply("FUNCTIONS_WORKER_RUNTIME"));
    }
}

