/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.AiSemanticAttributes;
import com.azure.monitor.opentelemetry.exporter.implementation.Mappings;
import com.azure.monitor.opentelemetry.exporter.implementation.MappingsBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.SemanticAttributes;
import com.azure.monitor.opentelemetry.exporter.implementation.SpanDataMapper;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.MetricPointBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.MetricTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.configuration.ConnectionString;
import com.azure.monitor.opentelemetry.exporter.implementation.models.ContextTagKeys;
import com.azure.monitor.opentelemetry.exporter.implementation.models.TelemetryItem;
import com.azure.monitor.opentelemetry.exporter.implementation.preaggregatedmetrics.DependencyExtractor;
import com.azure.monitor.opentelemetry.exporter.implementation.preaggregatedmetrics.RequestExtractor;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.FormattedTime;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import reactor.util.annotation.Nullable;

public class MetricDataMapper {
    private static final ClientLogger logger = new ClientLogger(MetricDataMapper.class);
    private static final Set<String> OTEL_PRE_AGGREGATED_STANDARD_METRIC_NAMES = new HashSet<String>(4);
    private static final List<String> EXCLUDED_METRIC_NAMES = new ArrayList<String>();
    private static final Mappings MAPPINGS;
    private final BiConsumer<AbstractTelemetryBuilder, Resource> telemetryInitializer;
    private final boolean captureHttpServer4xxAsError;

    public MetricDataMapper(BiConsumer<AbstractTelemetryBuilder, Resource> telemetryInitializer, boolean captureHttpServer4xxAsError) {
        this.telemetryInitializer = telemetryInitializer;
        this.captureHttpServer4xxAsError = captureHttpServer4xxAsError;
    }

    public void map(MetricData metricData, Consumer<TelemetryItem> consumer) {
        if (EXCLUDED_METRIC_NAMES.contains(metricData.getName())) {
            return;
        }
        MetricDataType type = metricData.getType();
        if (type == MetricDataType.DOUBLE_SUM || type == MetricDataType.DOUBLE_GAUGE || type == MetricDataType.LONG_SUM || type == MetricDataType.LONG_GAUGE || type == MetricDataType.HISTOGRAM) {
            boolean isPreAggregatedStandardMetric = OTEL_PRE_AGGREGATED_STANDARD_METRIC_NAMES.contains(metricData.getName());
            List<TelemetryItem> telemetryItemList = this.convertOtelMetricToAzureMonitorMetric(metricData, isPreAggregatedStandardMetric);
            for (TelemetryItem telemetryItem : telemetryItemList) {
                consumer.accept(telemetryItem);
            }
        } else {
            logger.warning("metric data type {} is not supported yet.", new Object[]{metricData.getType()});
        }
    }

    private List<TelemetryItem> convertOtelMetricToAzureMonitorMetric(MetricData metricData, boolean isPreAggregatedStandardMetric) {
        ArrayList<TelemetryItem> telemetryItems = new ArrayList<TelemetryItem>();
        for (PointData pointData : metricData.getData().getPoints()) {
            MetricTelemetryBuilder builder = MetricTelemetryBuilder.create();
            this.telemetryInitializer.accept(builder, metricData.getResource());
            builder.setTime(FormattedTime.offSetDateTimeFromEpochNanos(pointData.getEpochNanos()));
            MetricDataMapper.updateMetricPointBuilder(builder, metricData, pointData, this.captureHttpServer4xxAsError, isPreAggregatedStandardMetric);
            telemetryItems.add(builder.build());
        }
        return telemetryItems;
    }

    public static void updateMetricPointBuilder(MetricTelemetryBuilder metricTelemetryBuilder, MetricData metricData, PointData pointData, boolean captureHttpServer4xxAsError, boolean isPreAggregatedStandardMetric) {
        double pointDataValue;
        Utils.checkArgument((metricData != null ? 1 : 0) != 0, (String)"MetricData cannot be null.");
        MetricPointBuilder pointBuilder = new MetricPointBuilder();
        MetricDataType type = metricData.getType();
        switch (type) {
            case LONG_SUM: 
            case LONG_GAUGE: {
                pointDataValue = ((LongPointData)pointData).getValue();
                break;
            }
            case DOUBLE_SUM: 
            case DOUBLE_GAUGE: {
                pointDataValue = ((DoublePointData)pointData).getValue();
                break;
            }
            case HISTOGRAM: {
                long histogramCount = ((HistogramPointData)pointData).getCount();
                if (histogramCount <= Integer.MAX_VALUE && histogramCount >= Integer.MIN_VALUE) {
                    pointBuilder.setCount((int)histogramCount);
                }
                HistogramPointData histogramPointData = (HistogramPointData)pointData;
                pointDataValue = histogramPointData.getSum();
                pointBuilder.setMin(histogramPointData.getMin());
                pointBuilder.setMax(histogramPointData.getMax());
                break;
            }
            default: {
                throw new IllegalArgumentException("metric data type '" + type + "' is not supported yet");
            }
        }
        pointBuilder.setValue(pointDataValue);
        pointBuilder.setName(metricData.getName());
        metricTelemetryBuilder.setMetricPoint(pointBuilder);
        Attributes attributes = pointData.getAttributes();
        if (isPreAggregatedStandardMetric) {
            Long statusCode = (Long)attributes.get(SemanticAttributes.HTTP_STATUS_CODE);
            boolean success = MetricDataMapper.isSuccess(statusCode, captureHttpServer4xxAsError);
            Boolean isSynthetic = (Boolean)attributes.get(AiSemanticAttributes.IS_SYNTHETIC);
            attributes.forEach((key, value) -> MetricDataMapper.applyConnectionStringAndRoleNameOverrides(metricTelemetryBuilder, value, key.getKey()));
            if (metricData.getName().contains(".server.")) {
                RequestExtractor.extract(metricTelemetryBuilder, statusCode, success, isSynthetic);
            } else if (metricData.getName().contains(".client.")) {
                int defaultPort;
                String dependencyType;
                if (metricData.getName().startsWith("http")) {
                    dependencyType = "Http";
                    defaultPort = MetricDataMapper.getDefaultPortForHttpScheme((String)attributes.get(SemanticAttributes.HTTP_SCHEME));
                } else {
                    dependencyType = (String)attributes.get(SemanticAttributes.RPC_SYSTEM);
                    if (dependencyType == null) {
                        dependencyType = "Unknown";
                    }
                    defaultPort = Integer.MAX_VALUE;
                }
                String target = SpanDataMapper.getTargetOrDefault(attributes, defaultPort, dependencyType);
                DependencyExtractor.extract(metricTelemetryBuilder, statusCode, success, dependencyType, target, isSynthetic);
            }
        } else {
            MAPPINGS.map(attributes, metricTelemetryBuilder);
        }
    }

    static boolean applyConnectionStringAndRoleNameOverrides(AbstractTelemetryBuilder telemetryBuilder, Object value, String key) {
        if (key.equals(AiSemanticAttributes.INTERNAL_CONNECTION_STRING.getKey()) && value instanceof String) {
            telemetryBuilder.setConnectionString(ConnectionString.parse((String)value));
            return true;
        }
        if (key.equals(AiSemanticAttributes.INTERNAL_ROLE_NAME.getKey()) && value instanceof String) {
            telemetryBuilder.addTag(ContextTagKeys.AI_CLOUD_ROLE.toString(), (String)value);
            return true;
        }
        return false;
    }

    private static int getDefaultPortForHttpScheme(@Nullable String httpScheme) {
        if (httpScheme == null) {
            return Integer.MAX_VALUE;
        }
        if (httpScheme.equals("https")) {
            return 443;
        }
        if (httpScheme.equals("http")) {
            return 80;
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isSuccess(Long statusCode, boolean captureHttpServer4xxAsError) {
        if (captureHttpServer4xxAsError) {
            return statusCode == null || statusCode < 400L;
        }
        return statusCode == null || statusCode < 500L;
    }

    static {
        EXCLUDED_METRIC_NAMES.add("http.server.active_requests");
        OTEL_PRE_AGGREGATED_STANDARD_METRIC_NAMES.add("http.server.duration");
        OTEL_PRE_AGGREGATED_STANDARD_METRIC_NAMES.add("http.client.duration");
        OTEL_PRE_AGGREGATED_STANDARD_METRIC_NAMES.add("rpc.client.duration");
        OTEL_PRE_AGGREGATED_STANDARD_METRIC_NAMES.add("rpc.server.duration");
        MAPPINGS = new MappingsBuilder().build();
    }
}

