/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation;

import com.azure.monitor.opentelemetry.exporter.implementation.AiSemanticAttributes;
import com.azure.monitor.opentelemetry.exporter.implementation.SemanticAttributes;
import io.opentelemetry.sdk.trace.ReadableSpan;

public final class OperationNames {
    public static String getOperationName(ReadableSpan span) {
        String operationName = (String)span.getAttribute(AiSemanticAttributes.OPERATION_NAME);
        if (operationName != null) {
            return operationName;
        }
        String spanName = span.getName();
        String httpMethod = (String)span.getAttribute(SemanticAttributes.HTTP_METHOD);
        if (httpMethod != null && !httpMethod.isEmpty() && spanName.startsWith("/")) {
            return httpMethod + " " + spanName;
        }
        return spanName;
    }

    private OperationNames() {
    }
}

