/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.localstorage;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalFileLoader;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalFileSenderTelemetryPipelineListener;
import com.azure.monitor.opentelemetry.exporter.implementation.logging.DiagnosticTelemetryPipelineListener;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipeline;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineListener;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.ThreadPoolUtils;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class LocalFileSender
implements Runnable {
    private static final ClientLogger logger = new ClientLogger(LocalFileSender.class);
    private final LocalFileLoader localFileLoader;
    private final TelemetryPipeline telemetryPipeline;
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(ThreadPoolUtils.createDaemonThreadFactory(LocalFileLoader.class));
    private final TelemetryPipelineListener diagnosticListener;

    LocalFileSender(long intervalSeconds, LocalFileLoader localFileLoader, TelemetryPipeline telemetryPipeline, boolean suppressWarnings) {
        this.localFileLoader = localFileLoader;
        this.telemetryPipeline = telemetryPipeline;
        this.diagnosticListener = suppressWarnings ? TelemetryPipelineListener.noop() : new DiagnosticTelemetryPipelineListener("Sending telemetry to the ingestion service (retry from disk)", false);
        this.scheduledExecutor.scheduleWithFixedDelay(this, intervalSeconds, intervalSeconds, TimeUnit.SECONDS);
    }

    void shutdown() {
        this.scheduledExecutor.shutdown();
    }

    @Override
    public void run() {
        try {
            LocalFileLoader.PersistedFile persistedFile = this.localFileLoader.loadTelemetriesFromDisk();
            if (persistedFile != null) {
                CompletableResultCode resultCode = this.telemetryPipeline.send(Collections.singletonList(persistedFile.rawBytes), persistedFile.connectionString, TelemetryPipelineListener.composite(this.diagnosticListener, new LocalFileSenderTelemetryPipelineListener(this.localFileLoader, persistedFile.file)));
                resultCode.join(30L, TimeUnit.SECONDS);
            }
        }
        catch (RuntimeException ex) {
            logger.error("Unexpected error occurred while sending telemetries from the local storage.", new Object[]{ex});
        }
    }
}

