/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.localstorage;

import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalFileCache;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalFileLoader;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalFilePurger;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalFileSender;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalFileWriter;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalStorageStats;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipeline;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineListener;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineRequest;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineResponse;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.StatusCode;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public class LocalStorageTelemetryPipelineListener
implements TelemetryPipelineListener {
    private final LocalFileWriter localFileWriter;
    private final LocalFileSender localFileSender;
    private final LocalFilePurger localFilePurger;
    private final AtomicBoolean shutdown = new AtomicBoolean();

    public LocalStorageTelemetryPipelineListener(int diskPersistenceMaxSizeMb, File telemetryFolder, TelemetryPipeline pipeline, LocalStorageStats stats, boolean suppressWarnings) {
        LocalFileCache localFileCache = new LocalFileCache(telemetryFolder);
        LocalFileLoader loader = new LocalFileLoader(localFileCache, telemetryFolder, stats, suppressWarnings);
        this.localFileWriter = new LocalFileWriter(diskPersistenceMaxSizeMb, localFileCache, telemetryFolder, stats, suppressWarnings);
        long intervalSeconds = diskPersistenceMaxSizeMb > 50 ? 10L : 30L;
        this.localFileSender = new LocalFileSender(intervalSeconds, loader, pipeline, suppressWarnings);
        this.localFilePurger = new LocalFilePurger(telemetryFolder, suppressWarnings);
    }

    @Override
    public void onResponse(TelemetryPipelineRequest request, TelemetryPipelineResponse response) {
        if (StatusCode.isRetryable(response.getStatusCode())) {
            this.localFileWriter.writeToDisk(request.getConnectionString(), request.getTelemetry());
        }
    }

    @Override
    public void onException(TelemetryPipelineRequest request, String errorMessage, Throwable throwable) {
        this.localFileWriter.writeToDisk(request.getConnectionString(), request.getTelemetry());
    }

    @Override
    public CompletableResultCode shutdown() {
        if (!this.shutdown.getAndSet(true)) {
            this.localFileSender.shutdown();
            this.localFilePurger.shutdown();
        }
        return CompletableResultCode.ofSuccess();
    }
}

