/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.logging;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.logging.NetworkFriendlyExceptions;
import com.azure.monitor.opentelemetry.exporter.implementation.logging.OperationLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipeline;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineListener;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineRequest;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineResponse;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.AzureMonitorMsgId;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class DiagnosticTelemetryPipelineListener
implements TelemetryPipelineListener {
    private static final Class<?> FOR_CLASS = TelemetryPipeline.class;
    private static final ClientLogger logger = new ClientLogger(FOR_CLASS);
    private static final AtomicBoolean friendlyExceptionThrown = new AtomicBoolean();
    private final OperationLogger operationLogger;
    private final boolean suppressWarningsOnRetryableFailures;

    public DiagnosticTelemetryPipelineListener(String operation, boolean suppressWarningsOnRetryableFailures) {
        this.operationLogger = new OperationLogger(FOR_CLASS, operation);
        this.suppressWarningsOnRetryableFailures = suppressWarningsOnRetryableFailures;
    }

    @Override
    public void onResponse(TelemetryPipelineRequest request, TelemetryPipelineResponse response) {
        int responseCode = response.getStatusCode();
        switch (responseCode) {
            case 200: {
                this.operationLogger.recordSuccess();
                break;
            }
            case 206: 
            case 400: {
                Set<String> errors = DiagnosticTelemetryPipelineListener.getErrors(response.getBody());
                if (errors.isEmpty()) break;
                this.operationLogger.recordFailure("Received response code " + responseCode + " (" + String.join((CharSequence)", ", errors) + ")", AzureMonitorMsgId.INGESTION_ERROR);
                break;
            }
            case 307: 
            case 308: {
                this.operationLogger.recordFailure("Too many redirects", AzureMonitorMsgId.INGESTION_ERROR);
                break;
            }
            case 401: 
            case 403: {
                if (this.suppressWarningsOnRetryableFailures) break;
                this.operationLogger.recordFailure(DiagnosticTelemetryPipelineListener.getErrorMessageFromCredentialRelatedResponse(responseCode, response.getBody()), AzureMonitorMsgId.INGESTION_ERROR);
                break;
            }
            case 408: 
            case 429: 
            case 500: 
            case 503: {
                if (this.suppressWarningsOnRetryableFailures) break;
                this.operationLogger.recordFailure("Received response code " + responseCode + " (telemetry will be stored to disk and retried later)", AzureMonitorMsgId.INGESTION_ERROR);
                break;
            }
            case 402: {
                this.operationLogger.recordFailure("Received response code 402 (daily quota exceeded and throttled over extended time)", AzureMonitorMsgId.INGESTION_ERROR);
                break;
            }
            case 439: {
                this.operationLogger.recordFailure("Received response code 439 (daily quota exceeded and throttled over extended time)", AzureMonitorMsgId.INGESTION_ERROR);
                break;
            }
            default: {
                this.operationLogger.recordFailure("received response code: " + responseCode, AzureMonitorMsgId.INGESTION_ERROR);
            }
        }
    }

    @Override
    public void onException(TelemetryPipelineRequest request, String reason, Throwable throwable) {
        if (!NetworkFriendlyExceptions.logSpecialOneTimeFriendlyException(throwable, request.getUrl().toString(), friendlyExceptionThrown, logger)) {
            this.operationLogger.recordFailure(reason, throwable, AzureMonitorMsgId.INGESTION_ERROR);
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }

    private static Set<String> getErrors(String body) {
        JsonNode jsonNode;
        try {
            jsonNode = new ObjectMapper().readTree(body);
        }
        catch (JsonProcessingException e) {
            return Collections.singleton("Could not parse response");
        }
        ArrayList errorNodes = new ArrayList();
        jsonNode.get("errors").forEach(errorNodes::add);
        return errorNodes.stream().map(errorNode -> errorNode.get("message").asText()).filter(s -> !s.equals("Telemetry sampled out.")).collect(Collectors.toSet());
    }

    private static String getErrorMessageFromCredentialRelatedResponse(int responseCode, String responseBody) {
        JsonNode jsonNode;
        try {
            jsonNode = new ObjectMapper().readTree(responseBody);
        }
        catch (JsonProcessingException e) {
            return "Ingestion service returned " + responseCode + ", but could not parse response as json: " + responseBody;
        }
        String action = responseCode == 401 ? ". Please provide Azure Active Directory credentials" : ". Please check your Azure Active Directory credentials, they might be incorrect or expired";
        ArrayList errors = new ArrayList();
        jsonNode.get("errors").forEach(errors::add);
        return ((JsonNode)errors.get(0)).get("message").asText() + action + " (telemetry will be stored to disk and retried later)";
    }
}

