/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.pipeline;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;

public class TelemetryPipelineRequest {
    private volatile URL url;
    private final String connectionString;
    private final String instrumentationKey;
    private final List<ByteBuffer> telemetry;
    private final int contentLength;

    TelemetryPipelineRequest(URL url, String connectionString, String instrumentationKey, List<ByteBuffer> telemetry) {
        this.url = url;
        this.connectionString = connectionString;
        this.instrumentationKey = instrumentationKey;
        this.telemetry = telemetry;
        this.contentLength = telemetry.stream().mapToInt(Buffer::limit).sum();
    }

    public URL getUrl() {
        return this.url;
    }

    void setUrl(URL url) {
        this.url = url;
    }

    public List<ByteBuffer> getTelemetry() {
        return this.telemetry;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getInstrumentationKey() {
        return this.instrumentationKey;
    }

    HttpRequest createHttpRequest() {
        HttpRequest request = new HttpRequest(HttpMethod.POST, this.url);
        request.setBody(Flux.fromIterable(this.telemetry));
        request.setHeader("Content-Length", Integer.toString(this.contentLength));
        request.setHeader("User-Agent", "");
        request.setHeader("Content-Encoding", "gzip");
        return request;
    }
}

