/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.quickpulse;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseCoordinatorInitData;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseDataCollector;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseDataFetcher;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseDataSender;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseHeaderInfo;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulsePingSender;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.AzureMonitorMsgId;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.Strings;
import org.slf4j.MDC;
import reactor.util.annotation.Nullable;

final class QuickPulseCoordinator
implements Runnable {
    private static final ClientLogger logger = new ClientLogger(QuickPulseCoordinator.class);
    @Nullable
    private String qpsServiceRedirectedEndpoint;
    private long qpsServicePollingIntervalHintMillis;
    private volatile boolean stopped = false;
    private volatile boolean pingMode = true;
    private final QuickPulseDataCollector collector;
    private final QuickPulsePingSender pingSender;
    private final QuickPulseDataFetcher dataFetcher;
    private final QuickPulseDataSender dataSender;
    private final long waitBetweenPingsInMillis;
    private final long waitBetweenPostsInMillis;
    private final long waitOnErrorInMillis;

    QuickPulseCoordinator(QuickPulseCoordinatorInitData initData) {
        this.dataSender = initData.dataSender;
        this.pingSender = initData.pingSender;
        this.dataFetcher = initData.dataFetcher;
        this.collector = initData.collector;
        this.waitBetweenPingsInMillis = initData.waitBetweenPingsInMillis;
        this.waitBetweenPostsInMillis = initData.waitBetweenPostsInMillis;
        this.waitOnErrorInMillis = initData.waitOnErrorInMillis;
        this.qpsServiceRedirectedEndpoint = null;
        this.qpsServicePollingIntervalHintMillis = -1L;
    }

    @Override
    public void run() {
        try {
            while (!this.stopped) {
                long sleepInMillis = this.pingMode ? this.ping() : this.sendData();
                Thread.sleep(sleepInMillis);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private long sendData() {
        this.dataFetcher.prepareQuickPulseDataForSend(this.qpsServiceRedirectedEndpoint);
        QuickPulseHeaderInfo currentQuickPulseHeaderInfo = this.dataSender.getQuickPulseHeaderInfo();
        this.handleReceivedHeaders(currentQuickPulseHeaderInfo);
        this.collector.setQuickPulseStatus(currentQuickPulseHeaderInfo.getQuickPulseStatus());
        switch (currentQuickPulseHeaderInfo.getQuickPulseStatus()) {
            case ERROR: {
                this.pingMode = true;
                return this.waitOnErrorInMillis;
            }
            case QP_IS_OFF: {
                this.pingMode = true;
                return this.qpsServicePollingIntervalHintMillis > 0L ? this.qpsServicePollingIntervalHintMillis : this.waitBetweenPingsInMillis;
            }
            case QP_IS_ON: {
                return this.waitBetweenPostsInMillis;
            }
        }
        try (MDC.MDCCloseable ignored = AzureMonitorMsgId.QUICK_PULSE_SEND_ERROR.makeActive();){
            logger.error("Critical error while sending QP data: unknown status, aborting");
        }
        this.collector.disable();
        this.stopped = true;
        return 0L;
    }

    private long ping() {
        QuickPulseHeaderInfo pingResult = this.pingSender.ping(this.qpsServiceRedirectedEndpoint);
        this.handleReceivedHeaders(pingResult);
        this.collector.setQuickPulseStatus(pingResult.getQuickPulseStatus());
        switch (pingResult.getQuickPulseStatus()) {
            case ERROR: {
                return this.waitOnErrorInMillis;
            }
            case QP_IS_ON: {
                this.pingMode = false;
                this.dataSender.startSending();
                return this.waitBetweenPostsInMillis;
            }
            case QP_IS_OFF: {
                return this.qpsServicePollingIntervalHintMillis > 0L ? this.qpsServicePollingIntervalHintMillis : this.waitBetweenPingsInMillis;
            }
        }
        try (MDC.MDCCloseable ignored = AzureMonitorMsgId.QUICK_PULSE_PING_ERROR.makeActive();){
            logger.error("Critical error while ping QP: unknown status, aborting");
        }
        this.collector.disable();
        this.stopped = true;
        return 0L;
    }

    private void handleReceivedHeaders(QuickPulseHeaderInfo currentQuickPulseHeaderInfo) {
        long newPollingInterval;
        String redirectLink = currentQuickPulseHeaderInfo.getQpsServiceEndpointRedirect();
        if (!Strings.isNullOrEmpty(redirectLink)) {
            this.qpsServiceRedirectedEndpoint = redirectLink;
        }
        if ((newPollingInterval = currentQuickPulseHeaderInfo.getQpsServicePollingInterval()) > 0L) {
            this.qpsServicePollingIntervalHintMillis = newPollingInterval;
        }
    }

    void stop() {
        this.stopped = true;
    }
}

