/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.quickpulse;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseHeaderInfo;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseNetworkHelper;
import com.azure.monitor.opentelemetry.exporter.implementation.quickpulse.QuickPulseStatus;
import java.util.concurrent.ArrayBlockingQueue;

class QuickPulseDataSender
implements Runnable {
    private final QuickPulseNetworkHelper networkHelper = new QuickPulseNetworkHelper();
    private final HttpPipeline httpPipeline;
    private volatile QuickPulseHeaderInfo quickPulseHeaderInfo;
    private long lastValidTransmission = 0L;
    private final ArrayBlockingQueue<HttpRequest> sendQueue;

    QuickPulseDataSender(HttpPipeline httpPipeline, ArrayBlockingQueue<HttpRequest> sendQueue) {
        this.httpPipeline = httpPipeline;
        this.sendQueue = sendQueue;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block11: while (true) lbl-1000:
        // 7 sources

        {
            try {
                post = this.sendQueue.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            if (this.quickPulseHeaderInfo.getQuickPulseStatus() != QuickPulseStatus.QP_IS_ON) continue;
            sendTime = System.nanoTime();
            response = (HttpResponse)this.httpPipeline.send(post).block();
            try {
                if (response == null) {
                    throw new AssertionError((Object)"http response mono returned empty");
                }
                if (!this.networkHelper.isSuccess(response)) continue;
                quickPulseHeaderInfo = this.networkHelper.getQuickPulseHeaderInfo(response);
                switch (1.$SwitchMap$com$azure$monitor$opentelemetry$exporter$implementation$quickpulse$QuickPulseStatus[quickPulseHeaderInfo.getQuickPulseStatus().ordinal()]) {
                    case 1: 
                    case 2: {
                        this.lastValidTransmission = sendTime;
                        this.quickPulseHeaderInfo = quickPulseHeaderInfo;
                        ** break;
                    }
                    case 3: {
                        this.onPostError(sendTime);
                        continue block11;
                    }
                    ** default:
lbl25:
                    // 1 sources

                    continue block11;
                }
            }
            finally {
                if (response == null) continue;
                response.close();
                continue;
            }
            break;
        }
    }

    void startSending() {
        this.quickPulseHeaderInfo = new QuickPulseHeaderInfo(QuickPulseStatus.QP_IS_ON);
    }

    QuickPulseHeaderInfo getQuickPulseHeaderInfo() {
        return this.quickPulseHeaderInfo;
    }

    private void onPostError(long sendTime) {
        double timeFromLastValidTransmission = (double)(sendTime - this.lastValidTransmission) / 1.0E9;
        if (timeFromLastValidTransmission >= 20.0) {
            this.quickPulseHeaderInfo = new QuickPulseHeaderInfo(QuickPulseStatus.ERROR);
        }
    }
}

