/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.pipeline;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

class AppInsightsByteBufferPool {
    private static final int BYTE_BUFFER_SIZE = 65536;
    private static final int MAX_RETAINED = 10;
    private final Queue<ByteBuffer> queue = new ArrayBlockingQueue<ByteBuffer>(10);

    AppInsightsByteBufferPool() {
    }

    ByteBuffer remove() {
        ByteBuffer byteBuffer = this.queue.poll();
        if (byteBuffer != null) {
            byteBuffer.clear();
            return byteBuffer;
        }
        return ByteBuffer.allocate(65536);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="this is just best effort returning byte buffers to the pool, so it's ok if the offer doesn't succeed, so there's no need to check the return value")
    void offer(List<ByteBuffer> byteBuffers) {
        for (ByteBuffer byteBuffer : byteBuffers) {
            this.queue.offer(byteBuffer);
        }
    }
}

