/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.statsbeat;

import com.azure.monitor.opentelemetry.exporter.implementation.builders.StatsbeatTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.OperatingSystem;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.ResourceProvider;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.PropertyHelper;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.SystemInformation;

public class CustomDimensions {
    private volatile ResourceProvider resourceProvider;
    private volatile OperatingSystem operatingSystem;
    private final String attachType;
    private final String runtimeVersion;
    private final String language;
    private final String sdkVersion;

    CustomDimensions() {
        String qualifiedSdkVersion = PropertyHelper.getQualifiedSdkVersionString();
        if (qualifiedSdkVersion.startsWith("awr")) {
            this.resourceProvider = ResourceProvider.RP_APPSVC;
            this.operatingSystem = OperatingSystem.OS_WINDOWS;
        } else if (qualifiedSdkVersion.startsWith("alr")) {
            this.resourceProvider = ResourceProvider.RP_APPSVC;
            this.operatingSystem = OperatingSystem.OS_LINUX;
        } else if (qualifiedSdkVersion.startsWith("kwr")) {
            this.resourceProvider = ResourceProvider.RP_AKS;
            this.operatingSystem = OperatingSystem.OS_WINDOWS;
        } else if (qualifiedSdkVersion.startsWith("klr")) {
            this.resourceProvider = ResourceProvider.RP_AKS;
            this.operatingSystem = OperatingSystem.OS_LINUX;
        } else if (qualifiedSdkVersion.startsWith("fwr")) {
            this.resourceProvider = ResourceProvider.RP_FUNCTIONS;
            this.operatingSystem = OperatingSystem.OS_WINDOWS;
        } else if (qualifiedSdkVersion.startsWith("flr")) {
            this.resourceProvider = ResourceProvider.RP_FUNCTIONS;
            this.operatingSystem = OperatingSystem.OS_LINUX;
        } else {
            this.resourceProvider = ResourceProvider.UNKNOWN;
            this.operatingSystem = CustomDimensions.initOperatingSystem();
        }
        this.sdkVersion = qualifiedSdkVersion.substring(qualifiedSdkVersion.lastIndexOf(58) + 1);
        this.runtimeVersion = System.getProperty("java.version");
        this.attachType = "codeless";
        this.language = "java";
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setResourceProvider(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
    }

    public void setOperatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    void populateProperties(StatsbeatTelemetryBuilder telemetryBuilder, String customerIkey) {
        telemetryBuilder.addProperty("rp", this.resourceProvider.getValue());
        telemetryBuilder.addProperty("os", this.operatingSystem.getValue());
        telemetryBuilder.addProperty("attach", this.attachType);
        telemetryBuilder.addProperty("cikey", customerIkey);
        telemetryBuilder.addProperty("runtimeVersion", this.runtimeVersion);
        telemetryBuilder.addProperty("language", this.language);
        telemetryBuilder.addProperty("version", this.sdkVersion);
    }

    private static OperatingSystem initOperatingSystem() {
        if (SystemInformation.isWindows()) {
            return OperatingSystem.OS_WINDOWS;
        }
        if (SystemInformation.isLinux()) {
            return OperatingSystem.OS_LINUX;
        }
        return OperatingSystem.OS_UNKNOWN;
    }
}

