/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.statsbeat;

import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineListener;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineRequest;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryPipelineResponse;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class StatsbeatTelemetryPipelineListener
implements TelemetryPipelineListener {
    private static final Set<Integer> RESPONSE_CODES_INDICATING_REACHED_BREEZE = new HashSet<Integer>(Arrays.asList(200, 206, 402, 408, 429, 439, 500));
    private final Runnable statsbeatShutdown;
    private final AtomicInteger statsbeatUnableToReachBreezeCounter = new AtomicInteger();
    private volatile boolean statsbeatHasReachedBreezeAtLeastOnce;

    public StatsbeatTelemetryPipelineListener(Runnable statsbeatShutdown) {
        this.statsbeatShutdown = statsbeatShutdown;
    }

    @Override
    public void onResponse(TelemetryPipelineRequest request, TelemetryPipelineResponse response) {
        int statusCode = response.getStatusCode();
        if (!this.statsbeatHasReachedBreezeAtLeastOnce) {
            if (RESPONSE_CODES_INDICATING_REACHED_BREEZE.contains(statusCode)) {
                this.statsbeatHasReachedBreezeAtLeastOnce = true;
            } else {
                this.statsbeatDidNotReachBreeze();
            }
        }
    }

    @Override
    public void onException(TelemetryPipelineRequest request, String errorMessage, Throwable throwable) {
        if (!this.statsbeatHasReachedBreezeAtLeastOnce) {
            this.statsbeatDidNotReachBreeze();
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }

    private void statsbeatDidNotReachBreeze() {
        if (this.statsbeatUnableToReachBreezeCounter.getAndIncrement() >= 10) {
            this.statsbeatShutdown.run();
        }
    }
}

