/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.utils;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.ResourceAttributes;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.HostName;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.Strings;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class AksResourceAttributes {
    private static final String AZURE_AKS = "azure_aks";
    private static final String UNKNOWN_SERVICE = "unknown_service";
    private static final ClientLogger logger = new ClientLogger(AksResourceAttributes.class);
    static Map<String, String> otelResourceAttributes = AksResourceAttributes.initOtelResourceAttributes();

    public static void reloadOtelResourceAttributes() {
        otelResourceAttributes = AksResourceAttributes.initOtelResourceAttributes();
    }

    public static Map<String, String> getOtelResourceAttributes() {
        return otelResourceAttributes;
    }

    public static boolean isAks() {
        return AZURE_AKS.equals(otelResourceAttributes.get(ResourceAttributes.CLOUD_PLATFORM.toString()));
    }

    public static String getAksRoleName() {
        String serviceName = otelResourceAttributes.get(ResourceAttributes.SERVICE_NAME.toString());
        if (!Strings.isNullOrEmpty(serviceName) && !serviceName.startsWith(UNKNOWN_SERVICE)) {
            return serviceName;
        }
        String k8sDeploymentName = otelResourceAttributes.get(ResourceAttributes.K8S_DEPLOYMENT_NAME.toString());
        if (!Strings.isNullOrEmpty(k8sDeploymentName)) {
            return k8sDeploymentName;
        }
        String k8sReplicaSetName = otelResourceAttributes.get(ResourceAttributes.K8S_REPLICASET_NAME.toString());
        if (!Strings.isNullOrEmpty(k8sReplicaSetName)) {
            return k8sReplicaSetName;
        }
        String k8sStatefulSetName = otelResourceAttributes.get(ResourceAttributes.K8S_STATEFULSET_NAME.toString());
        if (!Strings.isNullOrEmpty(k8sStatefulSetName)) {
            return k8sStatefulSetName;
        }
        String k8sJobName = otelResourceAttributes.get(ResourceAttributes.K8S_JOB_NAME.toString());
        if (!Strings.isNullOrEmpty(k8sJobName)) {
            return k8sJobName;
        }
        String k8sCronJobName = otelResourceAttributes.get(ResourceAttributes.K8S_CRONJOB_NAME.toString());
        if (!Strings.isNullOrEmpty(k8sCronJobName)) {
            return k8sCronJobName;
        }
        String k8sDaemonSetName = otelResourceAttributes.get(ResourceAttributes.K8S_DAEMONSET_NAME.toString());
        if (!Strings.isNullOrEmpty(k8sDaemonSetName)) {
            return k8sDaemonSetName;
        }
        return serviceName;
    }

    public static String getAksRoleInstance() {
        String serviceInstanceId = otelResourceAttributes.get(ResourceAttributes.SERVICE_INSTANCE_ID.toString());
        if (!Strings.isNullOrEmpty(serviceInstanceId)) {
            return serviceInstanceId;
        }
        String k8sPodName = otelResourceAttributes.get(ResourceAttributes.K8S_POD_NAME.toString());
        if (!Strings.isNullOrEmpty(k8sPodName)) {
            return k8sPodName;
        }
        return HostName.get();
    }

    private static Map<String, String> initOtelResourceAttributes() {
        Map originalMap = DefaultConfigProperties.create(Collections.emptyMap()).getMap("otel.resource.attributes");
        HashMap<String, String> decodedMap = new HashMap<String, String>(originalMap.size());
        originalMap.forEach((key, value) -> {
            try {
                decodedMap.put((String)key, URLDecoder.decode(value, StandardCharsets.UTF_8.displayName()));
            }
            catch (UnsupportedEncodingException e) {
                logger.warning("Fail to decode OTEL_RESOURCE_ATTRIBUTES value.", new Object[]{e});
            }
        });
        return decodedMap;
    }

    private AksResourceAttributes() {
    }
}

