/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.utils;

import com.azure.core.util.Configuration;
import com.azure.monitor.opentelemetry.exporter.implementation.ResourceAttributes;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.models.ContextTagKeys;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.AksResourceAttributes;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.HostName;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.Strings;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Map;

public final class ResourceParser {
    private static final String DEFAULT_SERVICE_NAME = "unknown_service:java";

    public static void updateRoleNameAndInstance(AbstractTelemetryBuilder builder, Resource resource, Configuration configuration) {
        if (AksResourceAttributes.isAks()) {
            builder.addTag(ContextTagKeys.AI_CLOUD_ROLE.toString(), AksResourceAttributes.getAksRoleName());
            builder.addTag(ContextTagKeys.AI_CLOUD_ROLE_INSTANCE.toString(), AksResourceAttributes.getAksRoleInstance());
            return;
        }
        Map<String, String> existingTags = builder.build().getTags();
        if (existingTags == null || !existingTags.containsKey(ContextTagKeys.AI_CLOUD_ROLE.toString())) {
            String websiteSiteName;
            String serviceName = (String)resource.getAttribute(ResourceAttributes.SERVICE_NAME);
            if ((serviceName == null || DEFAULT_SERVICE_NAME.equals(serviceName)) && (websiteSiteName = Strings.trimAndEmptyToNull(configuration.get("WEBSITE_SITE_NAME"))) != null) {
                serviceName = websiteSiteName;
            }
            String serviceNamespace = (String)resource.getAttribute(ResourceAttributes.SERVICE_NAMESPACE);
            String roleName = null;
            if (serviceName != null && serviceNamespace != null) {
                roleName = "[" + serviceNamespace + "]/" + serviceName;
            } else if (serviceName != null) {
                roleName = serviceName;
            } else if (serviceNamespace != null) {
                roleName = "[" + serviceNamespace + "]";
            }
            if (roleName != null) {
                builder.addTag(ContextTagKeys.AI_CLOUD_ROLE.toString(), roleName);
            }
        }
        if (existingTags == null || !existingTags.containsKey(ContextTagKeys.AI_CLOUD_ROLE_INSTANCE.toString())) {
            String roleInstance = (String)resource.getAttribute(ResourceAttributes.SERVICE_INSTANCE_ID);
            if (roleInstance == null) {
                roleInstance = Strings.trimAndEmptyToNull(configuration.get("WEBSITE_INSTANCE_ID"));
            }
            if (roleInstance == null) {
                roleInstance = HostName.get();
            }
            if (roleInstance != null) {
                builder.addTag(ContextTagKeys.AI_CLOUD_ROLE_INSTANCE.toString(), roleInstance);
            }
        }
    }

    private ResourceParser() {
    }
}

