/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.monitor.query.implementation.logs.AzureLogAnalyticsImpl;
import com.azure.monitor.query.implementation.logs.models.BatchRequest;
import com.azure.monitor.query.implementation.logs.models.BatchResponse;
import com.azure.monitor.query.implementation.logs.models.ErrorResponseException;
import com.azure.monitor.query.implementation.logs.models.QueryBody;
import com.azure.monitor.query.implementation.logs.models.QueryResults;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class QueriesImpl {
    private final QueriesService service;
    private final AzureLogAnalyticsImpl client;

    QueriesImpl(AzureLogAnalyticsImpl client) {
        this.service = (QueriesService)RestProxy.create(QueriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueryResults>> getWithResponseAsync(String workspaceId, String query, Duration timespan) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (query == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter query is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getHost(), workspaceId, query, timespan, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueryResults>> getWithResponseAsync(String workspaceId, String query, Duration timespan, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (query == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter query is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.get(this.client.getHost(), workspaceId, query, timespan, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueryResults> getAsync(String workspaceId, String query, Duration timespan) {
        return this.getWithResponseAsync(workspaceId, query, timespan).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((QueryResults)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueryResults> getAsync(String workspaceId, String query, Duration timespan, Context context) {
        return this.getWithResponseAsync(workspaceId, query, timespan, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((QueryResults)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueryResults get(String workspaceId, String query, Duration timespan) {
        return (QueryResults)this.getAsync(workspaceId, query, timespan).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueryResults> getWithResponse(String workspaceId, String query, Duration timespan, Context context) {
        return (Response)this.getWithResponseAsync(workspaceId, query, timespan, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueryResults>> executeWithResponseAsync(String workspaceId, QueryBody body, String prefer) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.execute(this.client.getHost(), workspaceId, prefer, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueryResults>> executeWithResponseAsync(String workspaceId, QueryBody body, String prefer, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return this.service.execute(this.client.getHost(), workspaceId, prefer, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueryResults> executeAsync(String workspaceId, QueryBody body, String prefer) {
        return this.executeWithResponseAsync(workspaceId, body, prefer).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((QueryResults)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueryResults> executeAsync(String workspaceId, QueryBody body, String prefer, Context context) {
        return this.executeWithResponseAsync(workspaceId, body, prefer, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((QueryResults)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueryResults execute(String workspaceId, QueryBody body, String prefer) {
        return (QueryResults)this.executeAsync(workspaceId, body, prefer).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueryResults> executeWithResponse(String workspaceId, QueryBody body, String prefer, Context context) {
        return (Response)this.executeWithResponseAsync(workspaceId, body, prefer, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BatchResponse>> batchWithResponseAsync(BatchRequest body) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.batch(this.client.getHost(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BatchResponse>> batchWithResponseAsync(BatchRequest body, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return this.service.batch(this.client.getHost(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchResponse> batchAsync(BatchRequest body) {
        return this.batchWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((BatchResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchResponse> batchAsync(BatchRequest body, Context context) {
        return this.batchWithResponseAsync(body, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((BatchResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchResponse batch(BatchRequest body) {
        return (BatchResponse)this.batchAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BatchResponse> batchWithResponse(BatchRequest body, Context context) {
        return (Response)this.batchWithResponseAsync(body, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AzureLogAnalyticsQue")
    private static interface QueriesService {
        @Get(value="workspaces/{workspaceId}/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<QueryResults>> get(@HostParam(value="$host") String var1, @PathParam(value="workspaceId") String var2, @QueryParam(value="query") String var3, @QueryParam(value="timespan") Duration var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="workspaces/{workspaceId}/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<QueryResults>> execute(@HostParam(value="$host") String var1, @PathParam(value="workspaceId") String var2, @HeaderParam(value="Prefer") String var3, @BodyParam(value="application/json") QueryBody var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="$batch")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<BatchResponse>> batch(@HostParam(value="$host") String var1, @BodyParam(value="application/json") BatchRequest var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

