/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metrics;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.monitor.query.implementation.metrics.MonitorManagementClientImpl;
import com.azure.monitor.query.implementation.metrics.models.ErrorResponseException;
import com.azure.monitor.query.implementation.metrics.models.MetricsResponse;
import com.azure.monitor.query.implementation.metrics.models.ResultType;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class MetricsImpl {
    private final MetricsService service;
    private final MonitorManagementClientImpl client;

    MetricsImpl(MonitorManagementClientImpl client) {
        this.service = (MetricsService)RestProxy.create(MetricsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricsResponse>> listWithResponseAsync(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderby, String filter, ResultType resultType, String metricnamespace) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getHost(), resourceUri, timespan, interval, metricnames, aggregation, top, orderby, filter, resultType, this.client.getApiVersion(), metricnamespace, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricsResponse>> listWithResponseAsync(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderby, String filter, ResultType resultType, String metricnamespace, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.list(this.client.getHost(), resourceUri, timespan, interval, metricnames, aggregation, top, orderby, filter, resultType, this.client.getApiVersion(), metricnamespace, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricsResponse> listAsync(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderby, String filter, ResultType resultType, String metricnamespace) {
        return this.listWithResponseAsync(resourceUri, timespan, interval, metricnames, aggregation, top, orderby, filter, resultType, metricnamespace).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MetricsResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricsResponse> listAsync(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderby, String filter, ResultType resultType, String metricnamespace, Context context) {
        return this.listWithResponseAsync(resourceUri, timespan, interval, metricnames, aggregation, top, orderby, filter, resultType, metricnamespace, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MetricsResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetricsResponse list(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderby, String filter, ResultType resultType, String metricnamespace) {
        return (MetricsResponse)this.listAsync(resourceUri, timespan, interval, metricnames, aggregation, top, orderby, filter, resultType, metricnamespace).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetricsResponse> listWithResponse(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderby, String filter, ResultType resultType, String metricnamespace, Context context) {
        return (Response)this.listWithResponseAsync(resourceUri, timespan, interval, metricnames, aggregation, top, orderby, filter, resultType, metricnamespace, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorManagementCli")
    private static interface MetricsService {
        @Get(value="/{resourceUri}/providers/microsoft.insights/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<MetricsResponse>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="timespan") String var3, @QueryParam(value="interval") Duration var4, @QueryParam(value="metricnames") String var5, @QueryParam(value="aggregation") String var6, @QueryParam(value="top") Integer var7, @QueryParam(value="orderby") String var8, @QueryParam(value="$filter") String var9, @QueryParam(value="resultType") ResultType var10, @QueryParam(value="api-version") String var11, @QueryParam(value="metricnamespace") String var12, @HeaderParam(value="Accept") String var13, Context var14);
    }
}

